package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.mealstand;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.order.order.MealOrder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerMealDiscountComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealDiscountContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.MealDiscountPresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount.CouponFragment;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount.NomalDiscountFragment;
import com.gingersoft.gsa.cloud.ui.adapter.ViewPager2Adapter;
import com.gingersoft.gsa.cloud.ui.view.MyTableView;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:46
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@Deprecated
public class MealDiscountFragment extends BaseFragment<MealDiscountPresenter> implements MealDiscountContract.View {

    @BindView(R2.id.tabLayout)
    MyTableView tabLayout;
    @BindView(R2.id.viewPager2)
    ViewPager2 viewPager2;

    private String[] mTabTitles = {"折扣", "優惠券"};

    public static MealDiscountFragment newInstance() {
        MealDiscountFragment fragment = new MealDiscountFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerMealDiscountComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_meal_discount, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initViewPager();
    }

    private void initViewPager() {
        List<Fragment> fragments = new ArrayList<>();
        fragments.add(NomalDiscountFragment.newInstance());
        MemberInfo memberInfo = MealOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            fragments.add(CouponFragment.newInstance(CouponFragment.FOOD_LIMIT_DISCOUNT));
        }
        //实例化适配器
        ViewPager2Adapter viewPager2Adapter = new ViewPager2Adapter(_mActivity, fragments);
        //设置Viewpager2的适配器
        viewPager2.setAdapter(viewPager2Adapter);
        //TabLayout綁定Viewpager2
        TabLayoutMediator tab = new TabLayoutMediator(tabLayout, viewPager2, true, new TabLayoutMediator.TabConfigurationStrategy() {

            @Override
            public void onConfigureTab(@NonNull TabLayout.Tab tab, int position) {
                tab.setText(mTabTitles[position]);
            }
        });
        tab.attach();
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
