package com.gingersoft.gsa.cloud.common.constans;

import com.gingersoft.gsa.cloud.common.function.FModule;
import com.gingersoft.gsa.cloud.common.function.XFunctionItems;

/**
 * @author admin
 * 外送按鈕功能權限
 */
public class Takeaway {

    public static final String TAKEAWAY_ORDER_DETAILS = "takeaway/orderDetails/btn/";
    public static final String TAKEAWAY_ORDER_DETAILS_ENFORCE = "takeaway/orderDetails/btn/enforce/";

    public static final String TAKEAWAY_BTN = "takeaway/btn/";

    public static final String CONFIRM_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "confirmOrder";
    public static final String PRODUCTION_COMPLETED_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "ProductionCompleted";
    public static final String CANCEL_ORDER_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "cancelOrder";
    public static final String PRINT_ORDER_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "printOrder";
    public static final String LOGISTICS_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "logistics";
    public static final String ASSIGN_DELIVERY_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "assignDelivery";
    public static final String CLOSING_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "closing";
    public static final String TRANSPORTATION_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "transportation";
    public static final String ADDITIONAL_SERVICE_CHARGE_BTN_KEY = TAKEAWAY_ORDER_DETAILS + "additionalServiceCharge";
    /**
     * 新訂單
     */
    public static final String TAKEAWAY_NEW_ORDER = TAKEAWAY_BTN + "newOrder";
    /**
     * 歷史訂單
     */
    public static final String TAKEAWAY_HISTORY_ORDER = TAKEAWAY_BTN + "historyOrder";
    /**
     * 開錢箱
     */
    public static final String TAKEAWAY_OPEN_CASH_BOX = TAKEAWAY_BTN + "openCashBox";

    /**
     * 外送/自取- 訂單詳情管理
     */
    @XFunctionItems(TAKEAWAY_ORDER_DETAILS)
    public static final FModule[] ORDER_DETAILS_BTN_PERMISSION = {
            new FModule(CONFIRM_BTN_KEY, 0, 0),
            new FModule(PRODUCTION_COMPLETED_BTN_KEY, 0, 0),
            new FModule(CANCEL_ORDER_BTN_KEY, 0, 0),
            new FModule(PRINT_ORDER_BTN_KEY, 0, 0),
            new FModule(LOGISTICS_BTN_KEY, 0, 0),
            new FModule(ASSIGN_DELIVERY_BTN_KEY, 0, 0),
            new FModule(CLOSING_BTN_KEY, 0, 0),
            new FModule(TRANSPORTATION_BTN_KEY, 0, 0),
            new FModule(ADDITIONAL_SERVICE_CHARGE_BTN_KEY, 0, 0)
    };
    /**
     * 外送/自取- 訂單詳情強制按鈕
     */
    @XFunctionItems(TAKEAWAY_ORDER_DETAILS_ENFORCE)
    public static final FModule[] ORDER_DETAILS_BTN_ENFORCE_PERMISSION = {
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforceConfirmOrder", 0, 0),//強制確認訂單
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforceProductionCompleted", 0, 0),//強制製作完成
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforceCancelOrder", 0, 0),//強制取消訂單
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforcePrintOrder", 0, 0),//強制打印訂單
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforceCancelLogistics", 0, 0),//強制取消物流
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforceAssignDelivery", 0, 0),//強制指派送貨
            new FModule(TAKEAWAY_ORDER_DETAILS_ENFORCE + "EnforceClosing", 0, 0)//強制結賬
    };

    /**
     * 外送/自取- 首頁按鈕管理
     */
    @XFunctionItems(TAKEAWAY_BTN)
    public static final FModule[] TAKEAWAY_MAIN_BTN_PERMISSION = {
            new FModule(TAKEAWAY_NEW_ORDER, 0, 0),
            new FModule(TAKEAWAY_HISTORY_ORDER, 0, 0),
            new FModule(TAKEAWAY_OPEN_CASH_BOX, 0, 0)
    };

}
