package com.jess.arms.utils;

import android.text.InputFilter;
import android.text.Spanned;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 16:00
 * Use: 只能輸入英文字母、數字、-
 */
public class EnAndNumInputFilter implements InputFilter {
    /**
     * 只能輸入英文和數字
     */
    public static final Pattern ChAndEn = Pattern.compile("[-a-zA-Z0-9]+");

    @Override
    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        Matcher m = ChAndEn.matcher(source.toString());
        if (dest.toString().contains("-") && source.toString().equals("-")) {
            return "";
        }
        if (!m.matches()) {
            return "";
        }
        return null;
    }
}
