package com.gingersoft.gsa.cloud.database.bean;


import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Transient;

import lombok.Getter;
import lombok.Setter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
@Getter
@Setter
@Entity
public class Function {

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long dbid;

    @NotNull
    private int id;

    private int parentId;
    private int groupId;
    private long effectiveTime;
    private String resName;
    private String resUrl;
    private String imageURL;
    /**
     * 暫時沒有imageURL，用本地資源代替
     */
    private int icRes;
    /**
     * 狀態
     * 0 未开通
     * 1 正常
     * 2 有時間限制
     * 3 關閉
     */
    private int status;

    @Transient
    public static final int STATUS_NONACTIVATED = 0;
    @Transient
    public static final int STATUS_NONAL = 1;
    @Transient
    public static final int STATUS_TIME_LIMIT = 2;
    @Transient
    public static final int STATUS_CLOSE = 3;
    /**
     * 自定義字段
     */
    @Transient
    private int textColor;
    @Transient
    private int backgroundColor;
    @Transient
    private int textSize;

    @Transient
    private int nameRes;
    @Transient
    private int textColorRes;
    @Transient
    private int backgroundColorRes;
    @Transient
    private int textSizeRes;
    @Transient
    private int iconRes;

    @Transient
    private String lable;

    /**
     * 底部功能按鈕是否凸起
     */
    @Transient
    private boolean raisedBottom = false;


    @Generated(hash = 133141990)
    public Function() {
    }

    public Function(int id, String resName, int textColorRes, int textSizeRes, int iconRes) {
        this.id = id;
        this.resName = resName;
        this.textColorRes = textColorRes;
        this.textSizeRes = textSizeRes;
        this.iconRes = iconRes;
    }

    public Function(String resName, int textColor, int backgroundColor, int textSize) {
        this.resName = resName;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.textSize = textSize;
    }

    public Function(int id, int parentId, int groupId, String resName, int icRes, int status) {
        this.id = id;
        this.parentId = parentId;
        this.groupId = groupId;
        this.resName = resName;
        this.icRes = icRes;
        this.status = status;
    }

    public Function(int nameRes, int textColorRes, int backgroundColorRes, int textSizeRes) {
        this.nameRes = nameRes;
        this.textColorRes = textColorRes;
        this.backgroundColorRes = backgroundColorRes;
        this.textSizeRes = textSizeRes;
    }

    public Function(String resName, int icRes) {
        this.resName = resName;
        this.icRes = icRes;
    }

    @Generated(hash = 607723885)
    public Function(Long dbid, int id, int parentId, int groupId, long effectiveTime, String resName,
            String resUrl, String imageURL, int icRes, int status) {
        this.dbid = dbid;
        this.id = id;
        this.parentId = parentId;
        this.groupId = groupId;
        this.effectiveTime = effectiveTime;
        this.resName = resName;
        this.resUrl = resUrl;
        this.imageURL = imageURL;
        this.icRes = icRes;
        this.status = status;
    }

    @Override
    public String toString() {
        return "Function{" +
                "dbid=" + dbid +
                ", id=" + id +
                ", parentId=" + parentId +
                ", groupId=" + groupId +
                ", status=" + status +
                ", effectiveTime=" + effectiveTime +
                ", resName='" + resName + '\'' +
                ", resUrl='" + resUrl + '\'' +
                ", imageURL='" + imageURL + '\'' +
                ", icRes=" + icRes +
                ", textColor=" + textColor +
                ", backgroundColor=" + backgroundColor +
                ", textSize=" + textSize +
                ", nameRes=" + nameRes +
                ", textColorRes=" + textColorRes +
                ", backgroundColorRes=" + backgroundColorRes +
                ", textSizeRes=" + textSizeRes +
                ", iconRes=" + iconRes +
                ", lable='" + lable + '\'' +
                '}';
    }

    public Long getDbid() {
        return this.dbid;
    }

    public void setDbid(Long dbid) {
        this.dbid = dbid;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public long getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(long effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getResName() {
        return this.resName;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public String getResUrl() {
        return this.resUrl;
    }

    public void setResUrl(String resUrl) {
        this.resUrl = resUrl;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
    }

    public int getIcRes() {
        return this.icRes;
    }

    public void setIcRes(int icRes) {
        this.icRes = icRes;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}
