package com.gingersoft.gsa.cloud.pay.contract;

/**
 * @作者: bin
 * @創建時間: 2020-12-28 14:49
 * @更新時間: 2020-12-28 14:49
 * @描述: 支付異常碼，每個支付相關的error對應一個唯一的code，方便出問題時定位
 */
public interface PayExceptionCode {

    /**
     * pos回調為Null
     */
    String pos_response_null = "[100]";
    /**
     * pos回調status != 00
     */
    String pos_response_101 = "[101]";
    /**
     * pos回调解析发生JSONException
     */
    String pos_response_102 = "[102]";
    /**
     * pos回調 withException == true
     */
    String pos_response_105 = "[105]";



    /**
     * SaleActionImp getTxnId
     */
    String sale_401 = "[401]";
    String sale_402 = "[402]";
    String sale_403 = "[403]";
    String sale_404 = "[404]";

    /**
     * SaleActionImp onPosException
     */
    String sale_410 = "[410]";
    String sale_411 = "[411]";
    String sale_412 = "[412]";
    String sale_413 = "[413]";
    String sale_414 = "[414]";


    /**
     * RetrievalActionImp onPosException
     */
    String retrieval_513 = "[513]";
    String retrieval_514 = "[514]";


    /**
     * TipsActionImpl getTxnId
     */
    String tips_701 = "[701]";
    String tips_702 = "[702]";
    String tips_703 = "[703]";
    String tips_704 = "[704]";

    /**
     * TipsActionImpl onPosException
     */
    String tips_710 = "[710]";
    String tips_711 = "[711]";
    String tips_712 = "[712]";
    String tips_713 = "[713]";
    String tips_714 = "[714]";




    /**
     * VoidActionImpl getTxnId
     */
    String void_801 = "[801]";
    String void_802 = "[802]";
    String void_803 = "[803]";
    String void_804 = "[804]";

    /**
     * VoidActionImpl onPosException
     */
    String void_810 = "[810]";
    String void_811 = "[811]";
    String void_812 = "[812]";
    String void_813 = "[813]";
    String void_814 = "[814]";


    /**
     * RefundActionImpl getTxnId
     */
    String refund_901 = "[901]";
    String refund_902 = "[902]";
    String refund_903 = "[903]";
    String refund_904 = "[904]";

    /**
     * RefundActionImpl onPosException
     */
    String refund_910 = "[910]";
    String refund_911 = "[911]";
    String refund_912 = "[912]";
    String refund_913 = "[913]";
    String refund_914 = "[914]";
}
