package com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp;

import android.app.Activity;
import android.content.Context;

import com.etps.aca.lib.util.CommandUtil;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.PosCallbackListener;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.device.pos.base.bean.PosMatter;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.constant.HywebActionStatusCode;
import com.gingersoft.gsa.cloud.pay.widget.StatusLoadingDialog;
import com.jess.arms.mvp.IView;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019/6/13
 * 修订历史：2019/6/13
 * 描述：
 */
public abstract class IHywebAction<T extends HywebPosResponse> {

    protected final String TAG = this.getClass().getSimpleName();
    protected Context mContext;
    protected IView mView;
    protected PayAction mPosAction;
    protected PosCallbackListener mOnPosActionListener;

    protected StatusLoadingDialog mStatusLoadingDialog;

    private final String mLoadingActionText = "中...";
    private final String mLoadingActionComplteText = "成功";

    private final long mCancelDelayMillis = 2000;

    public IHywebAction(Context context, IView iView, PayAction action, boolean showLoading) {
        this.mContext = context;
        this.mView = iView;
        this.mPosAction = action;
        if (showLoading) {
            mStatusLoadingDialog = new StatusLoadingDialog(context, action.getActionName() + mLoadingActionText, mCancelDelayMillis);
            mStatusLoadingDialog.show();
        }
    }

    public PayAction getPosAction() {
        return mPosAction;
    }

    /**
     * 對POS幾發起操作前的業務處理,如將操作記錄添加到後台日誌表，事項表
     */
    public abstract void onPosActionBefore();


    /**
     * 向POS發起操作的方法
     */
    protected void onPosToAction(String requestJson) {
        CommandUtil.sendRequest(mContext, requestJson);
    }

    /**
     * 對POS幾發起操作前的業務處理异常 如记录事项调用出错
     *
     * @param e
     */
    public void onBeforeActionPosError(Exception e) {
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.setStatusText(mPosAction.getActionName() + e.getMessage());
            mStatusLoadingDialog.cancel();
        }
    }

    /**
     * POS回調成功的方法
     *
     * @param context
     * @param originalActivity
     * @param response
     */
    public void onPosSuccess(Context context, Activity originalActivity, T response) {
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.setStatusText(mPosAction.getActionName() + mLoadingActionComplteText);
            mStatusLoadingDialog.loadSuccess();
            mStatusLoadingDialog.cancel();
        }
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onPosSuccess(response);
        }
    }

    /**
     * POS回調為null或狀態異常
     */
    public void onPosException(Context context, Activity originalActivity, T response) {
        String codeRequest = HywebActionStatusCode.getHywebRequestTextByCode(response.getSTATUS());
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.setStatusText(mPosAction.getCallbackExceptionText() + codeRequest);
            mStatusLoadingDialog.loadFailure();
            mStatusLoadingDialog.cancel();
        }
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onPosException(response,new Exception(codeRequest));
        }
    }

    /**
     * POS調起失敗
     */
    public void onPosInvalid(Context context, Activity originalActivity, T response) {
        String codeRequest = HywebActionStatusCode.getHywebRequestTextByCode(response.getSTATUS());
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.setStatusText(mPosAction.getActionName() + codeRequest);
            mStatusLoadingDialog.loadFailure();
            mStatusLoadingDialog.cancel();
        }
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onPosInvalid(codeRequest);
        }
    }

    /**
     * 更新狀態成功
     *
     * @param response
     */
    public void onUpdateStatusSuccess(T response) {
//        if (mStatusLoadingDialog != null) {
//            mStatusLoadingDialog.setStatusText(mPosAction.getActionName() + HywebActionStatusCode.getHywebRequestTextByCode(response.getSTATUS()));
//            mStatusLoadingDialog.cancel();
//        }
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onUpdateStatusSuccess(response);
        }
    }

    /**
     * 更新狀態失败
     *
     * @param e
     */
    public void onUpdateStatusError(Exception e) {
//        if (mStatusLoadingDialog != null) {
//            mStatusLoadingDialog.setStatusText(mPosAction.getActionName() + e.getMessage());
//            mStatusLoadingDialog.cancel();
//        }
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onUpdateStatusError(e);
        }
    }

    protected void cancelLoadingDialog() {
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.cancel();
        }
    }

    /**
     * 根據業務回調狀態，返回事項上傳狀態
     *
     * @param status
     * @return
     */
    protected byte getPosMatterStatus(String status) {
        if (HywebActionStatusCode.withSuccess(status)) {
            return PosMatter.status_1;
        } else if (HywebActionStatusCode.withException(status)) {
            return PosMatter.status_0;
        } else {
            return PosMatter.status_2;
        }
    }

}
