package com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.order.R2;
import com.gingersoft.gsa.cloud.pay.PayStep;
import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.device.pos.base.lifecycle.fragment.PaymentCommandFragment;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.constant.YedpayConstant;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.di.component.DaggerYedpayComponent;
import com.gingersoft.gsa.cloud.pay.view.customstatus.CustomStatusView;
import com.jess.arms.di.component.AppComponent;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.contract.YedpayContract;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.presenter.YedpayPresenter;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/30/2021 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class YedpayFragment extends PaymentCommandFragment<YedpayPresenter> implements YedpayContract.View {

    @BindView(R2.id.ll_container)
    LinearLayout ll_container;
    @BindView(R2.id.as_status)
    CustomStatusView as_status;
    @BindView(R2.id.tv_status)
    TextView tv_status;

    public static YedpayFragment newInstance(RequestParms parms) {
        YedpayFragment fragment = new YedpayFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("requestParms", parms);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerYedpayComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        super.initData(savedInstanceState);

        mPresenter.apply(requestParms);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        LoganManager.w_code(TAG, "onActivityResult->" + "resultCode=" + resultCode + "  requestCode=" + requestCode);
        if (resultCode == android.app.Activity.RESULT_OK) {
            switch (requestCode) {
                case YedpayConstant.CallRequestCode.SALE_REQUEST_CODE:
                case YedpayConstant.CallRequestCode.RETRIEVAL_REQUEST_CODE:{
                    if (intent.getExtras() != null) {
                        String status = (String) intent.getExtras().get("status");
                        String transaction_id = (String) intent.getExtras().get("transaction_id");
                        LoganManager.w_code(TAG, "onActivityResult-》" + "status=" + status + "  transaction_id=" + transaction_id);
                        mPresenter.findSaleStatus(transaction_id, requestParms.getOrderId(), requestParms.getPayType(), requestParms.getResturantId(), requestParms.getTxnId());
                    }
                    break;
                }
                default:
                    showStatusLoadingDialog(PayStep.FAILURE);
                    break;
            }
        } else {
            showStatusLoadingDialog(PayStep.FAILURE);
        }
    }

    @Override
    public void startActivityForResult2(Intent intent,int requestCode) {
        startActivityForResult(intent,requestCode);
    }

    @Override
    public Fragment getFragment() {
        return this;
    }
}
