package com.gingersoft.gsa.cloud.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.ui.R;

public class ReloadView extends FrameLayout {

    private onReLoadListener onReLoadListener;

    public interface onReLoadListener {
        void onReLoad();
    }

    public ReloadView(@NonNull Context context) {
        this(context, null);
    }

    public ReloadView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ReloadView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        View view = View.inflate(context, R.layout.layout_reload, null);
        view.setOnClickListener(v -> {
            if(onReLoadListener != null){
                onReLoadListener.onReLoad();
            }
        });
        addView(view);
    }

    public void setOnReLoadListener(ReloadView.onReLoadListener onReLoadListener) {
        this.onReLoadListener = onReLoadListener;
    }
}
