package com.gingersoft.gsa.cloud.ui.view.edittext;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.android.material.textfield.TextInputEditText;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/2/4
 * Time: 15:04
 * Use: 獲取焦點時，內容為0，自動清除，
 * 失去焦點時，沒有內容，內容默認為0
 */
public class ClearZeroEditText extends TextInputEditText {

    private OnFocusChangeListener l;

    public ClearZeroEditText(@NonNull Context context) {
        super(context);
    }

    public ClearZeroEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ClearZeroEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }


    private void init() {
        setOnFocusChangeListener(new OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (l != null) {
                    l.onFocusChange(v, hasFocus);
                }
            }
        });
    }

    @Override
    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.l = l;
    }
}
