package com.gingersoft.gsa.cloud.ui.view.edittext;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.android.material.textfield.TextInputEditText;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/4/10
 * Time: 16:35
 * Use: 如果setEnabled(false) 則不響應點擊
 */
public class NoClickEditText extends TextInputEditText {
    public NoClickEditText(@NonNull Context context) {
        super(context);
    }

    public NoClickEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public NoClickEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return isEnabled() && super.onTouchEvent(event);
    }
}
