package view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.widget.ProgressBar;
import android.widget.TextView;

import teprinciple.updateapputils.R;

/**
 * @company: JOE工作室
 * @ClassName: DownloadDialog
 * @Description: TODO(下载进度对话框)
 * @Author: JOE
 * @Date: 2016-9-10 上午11:30:43
 */
public class DownloadDialog extends Dialog {
    private TextView textTitle;
    private ProgressBar progress_bar;
    private TextView progress_value;
    private TextView close_btn;
    private android.view.View.OnClickListener listener;

    public DownloadDialog(Context context) {
        super(context);
    }

    public DownloadDialog(Context context, int theme, android.view.View.OnClickListener listener) {
        super(context, theme);
        this.listener = listener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout_download_dialog);
        initView();
    }

    private void initView() {
        textTitle = (TextView) findViewById(R.id.dialog_title);
        progress_bar = (ProgressBar) findViewById(R.id.progress_bar);
        progress_value = (TextView) findViewById(R.id.progress_value);
        close_btn = (TextView) findViewById(R.id.close_btn);
        int themeColor = getContext().getResources().getColor(R.color.colorPrimary);
        textTitle.setTextColor(themeColor);
        progress_value.setTextColor(themeColor);
        close_btn.setTextColor(themeColor);
        close_btn.setOnClickListener(listener);
    }

    public void setTitle(String title) {
        textTitle.setText(title);
    }

    public void updateProgress(int value) {
        progress_value.setText(value + "%");
        progress_bar.setProgress(value);
        if (100 == value)
            dismiss();
    }


    public void setBottomText(String text) {
        close_btn.setText(text);
    }
}
