/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

public class RingBuffer {
    private byte[] mRingBuffer = null;
    private int mCapacity;
    private int mHead;
    private int mTail;
    private final Object mLockObj = new Object();

    public RingBuffer() throws Exception {
        throw new Exception();
    }

    public RingBuffer(int size) throws Exception {
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException();
        }
        this.mRingBuffer = new byte[size];
        this.mCapacity = size;
        this.mHead = 0;
        this.mTail = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(byte[] value, int offset, int valueSize) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (valueSize < 0 || offset < 0) {
            throw new IllegalArgumentException();
        }
        if (value.length - offset < valueSize) {
            throw new IllegalArgumentException();
        }
        if (valueSize == 0) {
            return;
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.isOverFlow(valueSize)) {
                throw new Exception();
            }
            for (int i = 0; i < valueSize; ++i) {
                this.mRingBuffer[this.mTail] = value[i + offset];
                this.mTail = this.mTail + 1 & this.mCapacity - 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeue(byte[] value, int offset, int valueSize) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (valueSize < 0 || offset < 0) {
            throw new IllegalArgumentException();
        }
        if (value.length - offset < valueSize) {
            throw new IllegalArgumentException();
        }
        if (valueSize == 0) {
            return 0;
        }
        int dataSizeInUse = 0;
        int dequeuedSize = 0;
        Object object = this.mLockObj;
        synchronized (object) {
            dataSizeInUse = this.mHead <= this.mTail ? this.mTail - this.mHead : this.mCapacity - (this.mHead - this.mTail);
            if (dataSizeInUse == 0) {
                dequeuedSize = 0;
                return dequeuedSize;
            }
            dequeuedSize = dataSizeInUse > valueSize ? valueSize : dataSizeInUse;
            for (int i = 0; i < dequeuedSize; ++i) {
                value[offset + i] = this.mRingBuffer[this.mHead];
                this.mHead = this.mHead + 1 & this.mCapacity - 1;
            }
        }
        return dequeuedSize;
    }

    private boolean isOverFlow(int dataSize) {
        boolean overFlow = false;
        int dataSizeInUse = 0;
        dataSizeInUse = this.mHead <= this.mTail ? this.mTail - this.mHead : this.mCapacity - (this.mHead - this.mTail);
        overFlow = dataSizeInUse + dataSize > this.mCapacity - 1;
        return overFlow;
    }
}

