package com.gingersoft.gsa.cloud.table.mvp.action.order;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.pay.bean.PosActionStatusExceptionParam;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.PosPay;
import com.gingersoft.gsa.cloud.pay.pos.fragment.PosActionStatusExceptionFragment;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.RefundRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.RefundRespose;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.mvp.IView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2021-01-15 15:19
 * @更新時間: 2021-01-15 15:19
 * @描述:订单退款
 */
public class RefundOrder implements Strategy<OrderManagerResponse> {

    private final  String TAG = "RefundlOrder";
    private BaseFragmentActivity mActivity;
    private IView mRootView;

    public RefundOrder(BaseFragmentActivity fragmentActivity, IView rootView){
        this.mActivity  = fragmentActivity;
        this.mRootView = rootView;
    }

    @Override
    public void action(OrderManagerResponse orderItem) {
        showHywebRefundDialog(orderItem);
    }

    @Override
    public void destroy() {

    }

    private void showHywebRefundDialog(OrderManagerResponse datasBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(mActivity);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否退款?");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            hywebRefund(datasBean);
        });
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    private void hywebRefund(OrderManagerResponse datasBean) {
        GetTxnIdRequest txnIdRequest = new GetTxnIdRequest();
        txnIdRequest.setOrderId(datasBean.getId());
        if (!TextUtils.isEmpty(datasBean.getTableNumber())) {
            txnIdRequest.setTableExtId(datasBean.getTableId());
        } else {
            txnIdRequest.setTableId(datasBean.getTableId());
        }
        txnIdRequest.setAmount(datasBean.getAmount());

        RefundRequest refundRequest = new RefundRequest();
        refundRequest.setPAYMENT_APP_ID(getPaymentAppIdByPays(datasBean.getOrderPays()));
        refundRequest.setTXN_AMT(datasBean.getAmount());
        PosPay.refund(mActivity, mRootView, refundRequest, txnIdRequest, new OnPosActionListener<RefundRespose>() {

            @Override
            public void onPosSuccess(RefundRespose response) {
                LoganManager.w_code(TAG, "onPosSuccess: " + response.toString());
                if(refundListener != null){
                    refundListener.refeshOrders();
                }
            }

            @Override
            public void onPosException(Exception e) {
                LoganManager.w_code(TAG, "onPosException: " + e.getMessage());
                if (mActivity.findFragment(PosActionStatusExceptionFragment.class) == null) {
                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
                    statusExceptionParam.setTxnId(datasBean.getPayTxnId());
                    statusExceptionParam.setAmount(datasBean.getAmount());
                    statusExceptionParam.setOrderId(datasBean.getId());
                    statusExceptionParam.setOrderNo(datasBean.getOrderNo());
                    statusExceptionParam.setPayMethodName("VISA測試");
                    statusExceptionParam.setPosAction(PosAction.REFUND);
                    mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
                }
            }

            @Override
            public void onPosInvalid(String e) {
                LoganManager.w_code(TAG, "onPosInvalid: " + e);
            }

            @Override
            public void onUpdateStatusSuccess(RefundRespose response) {
                LoganManager.w_code(TAG, "onUpdateStatusSuccess: " + response.toString());
            }


            @Override
            public void onUpdateStatusError(Throwable e) {
                LoganManager.w_code(TAG, "onUpdateStatusError: " + e.getMessage());
                if (mActivity.findFragment(PosActionStatusExceptionFragment.class) == null) {
                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
                    statusExceptionParam.setTxnId(datasBean.getPayTxnId());
                    statusExceptionParam.setAmount(datasBean.getAmount());
                    statusExceptionParam.setOrderId(datasBean.getId());
                    statusExceptionParam.setOrderNo(datasBean.getOrderNo());
                    statusExceptionParam.setPayMethodName("VISA測試");
                    statusExceptionParam.setPosAction(PosAction.REFUND);
                    mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
                }
            }
        });
    }

    private String getPaymentAppIdByPays(List<OrderManagerResponse.OrderPayBean> orderPays) {
        String hywebPayMethod = "";
        for (OrderManagerResponse.OrderPayBean orderPayBean : orderPays) {
            hywebPayMethod = orderPayBean.getHywebPayMethodByType();
        }
        return hywebPayMethod;
    }

    private RefundOrder.OnRefundListener refundListener;
    public void setRefundListener(RefundOrder.OnRefundListener refundListener) {
        this.refundListener = refundListener;
    }
    public interface OnRefundListener{
        void refeshOrders();
    }
}
