package com.gingersoft.gsa.other_order_mode.ui.activity

import android.os.Bundle
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.model.viewModel.HistoryOrderViewModel
import com.gingersoft.gsa.other_order_mode.ui.adapter.HistoryOrderAdapter
import com.gingersoft.gsa.other_order_mode.ui.base.BaseActivity
import com.gingersoft.gsa.other_order_mode.util.InjectorUtil
import com.gingersoft.gsa.other_order_mode.util.OtherOrderUtils
import kotlinx.android.synthetic.main.activity_history_order.*

class HistoryOrderActivity : BaseActivity() {

    private lateinit var mViewModel: HistoryOrderViewModel
    private var mHistoryOrderAdapter: HistoryOrderAdapter? = null
    private var pageIndex = 1

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_history_order)
        initAppTop()
        rv_history_order.layoutManager = LinearLayoutManager(this)
        initViewModel()
        getHistoryInfo()
        initSearch()
        initRefresh()
    }

    private fun getHistoryInfo(page: Int = pageIndex, orderNum: String = "") {
        showLoading()
        mViewModel.getHistoryOrderList(this, page.toString(), orderNum) {
            cancelDialogForLoading()
            refresh_layout.setEnableLoadMore(it.getData() != null)
            refresh_layout.finishRefresh()
            refresh_layout.finishLoadMore()
            if (mHistoryOrderAdapter == null) {
                mHistoryOrderAdapter = it.getData()?.let { it1 -> HistoryOrderAdapter(this@HistoryOrderActivity, it1) }
                rv_history_order.adapter = mHistoryOrderAdapter
                mHistoryOrderAdapter!!.setOnItemClickListenter {
                    showLoading()
                    mViewModel.getOrderInfo(it.Id.toString()) { it2 ->
                        cancelDialogForLoading()
                        if (it2.data != null && it2.data!!.isNotEmpty()) {
                            //顯示彈窗
                            OtherOrderUtils.showOrderDetailsDialog(this@HistoryOrderActivity, it2, it.STATUS, it.order_type, false) { _, _ ->
                                //確認訂單、指派送貨點擊事件
                            }
                        } else {
                            ToastUtils.show(this, "未查詢到訂單信息")
                        }
                    }
                }
            } else {
                mHistoryOrderAdapter!!.data = it.getData()
                mHistoryOrderAdapter!!.notifyDataSetChanged()
            }
        }
    }

    private fun initViewModel() {
        mViewModel = ViewModelProvider(this, InjectorUtil.getHistoryModelFactory())[HistoryOrderViewModel::class.java]
    }

    private fun initSearch() {
        iv_search_order.setOnClickListener {
            //搜索
            if (ed_order_num_search.text != null && ed_order_num_search.text.isNotEmpty()) {
                getHistoryInfo(1, ed_order_num_search.text.toString())
            } else {
                ToastUtils.show(this@HistoryOrderActivity, "請輸入手機號或訂單號")
            }
        }
    }

    private fun initRefresh() {
        //设置 Header 顏色
        refresh_layout.setPrimaryColorsId(R.color.color_f0, R.color.color_66)
        //下拉刷新，加載更多
        refresh_layout.setOnRefreshListener {
            pageIndex = 1
            getHistoryInfo()
        }
        refresh_layout.setOnLoadMoreListener {
            pageIndex++
            getHistoryInfo()
        }
    }

    private fun initAppTop() {
        qm_other_order_bar.setTitle(R.string.history_order)
        qm_other_order_bar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener { finish() }
        qm_other_order_bar.setBackgroundColor(resources.getColor(R.color.theme_color))
    }
}