package com.joe.print.mvp.ui.adapter;

import android.view.View;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;

import java.util.ArrayList;
import java.util.List;

public class PrintFailListAdapter extends BaseQuickAdapter<PrinterDeviceBean, BaseViewHolder> {


    /**
     * 0：打印失敗
     * 1：打印中，這時候重試按鈕和切換打印機按鈕都不顯示,顯示progress
     * 2：打印完成，刪除這條數據
     */
    private List<Integer> printStatus = new ArrayList<>();
    private onTryAgainPrintListenter tryAgainPrintListenter;
    private onSwitchPrintListenter switchPrintListenter;


    public PrintFailListAdapter(@Nullable List<PrinterDeviceBean> data) {
        super(R.layout.item_print_fail_layout, data);
        assert data != null;
        for (int i = 0; i < data.size(); i++) {
            printStatus.add(0);
        }
    }


    @Override
    public void remove(int position) {
        printStatus.remove(position);
        super.remove(position);
    }

    public void setTryAgainPrintListenter(onTryAgainPrintListenter tryAgainPrintListenter) {
        this.tryAgainPrintListenter = tryAgainPrintListenter;
    }

    public void setSwitchPrintListenter(onSwitchPrintListenter switchPrintListenter) {
        this.switchPrintListenter = switchPrintListenter;
    }

    public void setItemStatus(int position, int stauts) {
        if (position < printStatus.size()) {
            printStatus.set(position, stauts);
        }
        super.notifyItemChanged(position);
    }

    @Override
    protected void convert(BaseViewHolder helper, PrinterDeviceBean item) {
        helper.setText(R.id.tv_print_device_name, item.getName());
        if (tryAgainPrintListenter != null)
            helper.getView(R.id.tv_try_again_btn).setOnClickListener(v -> {
                tryAgainPrintListenter.onClick(helper.getAdapterPosition());
                setItemStatus(helper.getAdapterPosition(), 1);
            });

        if (switchPrintListenter != null)
            helper.getView(R.id.tv_switch_print_btn).setOnClickListener(v -> switchPrintListenter.onClick(helper.getAdapterPosition()));

        if (printStatus.get(helper.getAdapterPosition()) == 1) {
            helper.getView(R.id.loading_progress).setVisibility(View.VISIBLE);
            helper.getView(R.id.tv_print_status).setVisibility(View.VISIBLE);

            helper.getView(R.id.tv_try_again_btn).setVisibility(View.GONE);
            helper.getView(R.id.tv_switch_print_btn).setVisibility(View.GONE);
        } else {
            helper.getView(R.id.loading_progress).setVisibility(View.GONE);
            helper.getView(R.id.tv_print_status).setVisibility(View.GONE);

            helper.getView(R.id.tv_try_again_btn).setVisibility(View.VISIBLE);
            helper.getView(R.id.tv_switch_print_btn).setVisibility(View.VISIBLE);
        }
    }

    public interface onTryAgainPrintListenter {
        void onClick(int position);
    }

    public interface onSwitchPrintListenter {
        void onClick(int position);
    }

}
