package com.gingersoft.gsa.cloud.table.app.payment;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019/6/12
 * 修订历史：2019/6/12
 * 描述：
 */
public interface PayConstant {


    /**
     * N5異常问题 :
     *
     * 1、N5 POS 機操作超時：當操作超時時，N5 POS 機將返回主畫面，並向 ECR 發送 Status Code“98”的響應消息。ECR 應將此筆交易視為失敗。
     * 2、N5 POS 機忙碌：當 ECR 向處於忙碌狀態的 N5 POS 機發送請求時，ECR 將收到 Status Code “97”的響應。在發送另一個請求之前，ECR 應該提示消息要求用戶完成 N5 POS 機中的當前 交易。
     * 3、N5 POS機應用程序崩潰處理：當ECR發現N5 POS機的某些響應遺失時（這可能是由於應用程 序崩潰）。ECR應該向N5 POS機發送交易查詢請求命令，以獲取交易結果。
     *
     */

    /**
     * 支付状态
     */
    String PAY_STATUS_00 = "00"; //成功            √
    String PAY_STATUS_02 = "02"; //微信、支付宝正在处理这笔退款请求（可认为已成功）  √
    String PAY_STATUS_03 = "03"; //确认/处理 (支付、清機 同步接口防止N5機器關機未收到結果)   √
    String PAY_STATUS_09 = "09"; //用户取消        √
    String PAY_STATUS_10 = "10"; //主持人拒绝      √
    String PAY_STATUS_11 = "11"; //用户撤销（应用于仅限微信/支付宝）    √
    String PAY_STATUS_12 = "12"; //交易有已经作废/已完成
    String PAY_STATUS_13 = "13"; //找不到交易
    String PAY_STATUS_90 = "90"; //通讯/格式 错误   √
    String PAY_STATUS_91 = "91"; //功能或 付款方式没有 支持的    √
    String PAY_STATUS_97 = "97"; //N5 POS忙碌           √
    String PAY_STATUS_98 = "98"; //超时           √
    String PAY_STATUS_99 = "99"; //未知错误       √

    String PAY_STATUS_200 = "200"; //自定義錯誤提示       √


    /**
     * 支付申请清单
     */
    String PAY_TYPE_CC = "CC";
    String PAY_TYPE_QRC = "QRC";
    String PAY_TYPE_AE = "AE";

    //扫码支付
    String PAY_TYPE_QR = "QR";
    String PAY_TYPE_ALP = "ALP";
    String PAY_TYPE_WCP = "WCP";
    /**
     * 付款方式清单
     * <p>
     * VC Visa卡
     * VC-QR Visa卡QR
     * <p>
     * MC 万事达卡
     * MC-QR 万事达卡QR
     * <p>
     * JCB  JCB
     * JCB-QR JCB QR
     * <p>
     * UP 银联
     * UP-QR 银联QR
     * <p>
     * AE AMEX
     * <p>
     * ALP 支付宝
     * WCP 微信支付
     */

    String PAY_WAY_CASH = "CASH"; //现金
    String PAY_WAY_CARD = "CC"; //信用卡
    String PAY_WAY_AE = "AE"; //AMEX
    String PAY_WAY_QR = "QR"; //QR /条码付款（例如VMJ QR，UP QR）
    String PAY_WAY_ALI_WCP = "ALP,WCP"; //微信，支付宝


}
