package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.gingersoft.gsa.cloud.base.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.ui.view.PagerSlidingTabStrip;
import java.util.ArrayList;
import java.util.List;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;

public class BaseFragmentAdapter extends FragmentStatePagerAdapter implements PagerSlidingTabStrip.ViewTabProvider {

    private Context context;
    private List<Fragment> fragmentList = new ArrayList<Fragment>();
    private List<String> mTitles;

    public BaseFragmentAdapter(FragmentManager fm, List<Fragment> fragmentList) {
        super(fm);
        this.fragmentList = fragmentList;
    }

    public BaseFragmentAdapter(Context context, FragmentManager fm, List<Fragment> fragmentList, List<String> mTitles) {
        super(fm);
        this.context = context;
        this.fragmentList = fragmentList;
        this.mTitles = mTitles;
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return !CollectionUtils.isNullOrEmpty(mTitles) ? mTitles.get(position) : "";
    }

    @Override
    public Fragment getItem(int position) {
        return fragmentList.get(position);
    }

    @Override
    public int getCount() {
        return fragmentList.size();
    }

    @Override
    public View getTabView(int position) {
        View view = LayoutInflater.from(context).inflate(R.layout.table_view_tab_menu, null);
        return view;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        ////如果注释这行，那么不管怎么切换，page都不会被销毁
//        super.destroyItem(container, position, object);
    }


}
