package com.gingersoft.gsa.delivery_pick_mode.data.model.bean;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/16
 * Time: 14:47
 * Use: 餐廳外送的營業信息
 */
public class RestaurantBusinessInfo {
    // 當月支付成功的外賣單總數
    private int takeawayOrderNumber;
    // 當月支付成功的自取單總數
    private int selfCollectionOrderNumber;
    // 外賣訂單數
    private int maxOrderTakeaway;
    // 自取訂單數
    private int maxOrderSelf;
    // 餐廳狀態：0=休息中,1=營業中,2=繁忙中,3繁忙可接單
    private int openStatus;
    // 今日營業總金額
    private double sumTotalAmount;
    // 今日總訂單數
    private int sumOrderNumber;
    //外賣信息
    private TakeOutSelfInfoBean takeoutType;
    //自取信息
    private TakeOutSelfInfoBean selfCollectionType;
    // 即時單預約單信息
    private OrderAppointment orderAppointment;

    /**
     * 外賣自取信息
     */
    public static class TakeOutSelfInfoBean {
        // 當天外賣訂單金額
        private double totalAmount;
        // 當天外賣訂單數量
        private int dayOrderNumber;

        public double getTotalAmount() {
            return totalAmount;
        }

        public void setTotalAmount(double totalAmount) {
            this.totalAmount = totalAmount;
        }

        public int getDayOrderNumber() {
            return dayOrderNumber;
        }

        public void setDayOrderNumber(int dayOrderNumber) {
            this.dayOrderNumber = dayOrderNumber;
        }
    }

    /**
     * 即時單預約單
     */
    public static class OrderAppointment {
        // 預約單數量
        private int reservationNumber;
        // 即時單數量
        private int immediateNumber;
        // 預約單配置時間(分鐘)
        private long reservationConfigTime;

        public int getReservationNumber() {
            return reservationNumber;
        }

        public void setReservationNumber(int reservationNumber) {
            this.reservationNumber = reservationNumber;
        }

        public int getImmediateNumber() {
            return immediateNumber;
        }

        public void setImmediateNumber(int immediateNumber) {
            this.immediateNumber = immediateNumber;
        }

        public long getReservationConfigTime() {
            return reservationConfigTime;
        }

        public void setReservationConfigTime(long reservationConfigTime) {
            this.reservationConfigTime = reservationConfigTime;
        }
    }

    public int getSelfCollectionOrderNumber() {
        return selfCollectionOrderNumber;
    }

    public void setSelfCollectionOrderNumber(int selfCollectionOrderNumber) {
        this.selfCollectionOrderNumber = selfCollectionOrderNumber;
    }

    public int getMaxOrderTakeaway() {
        return maxOrderTakeaway;
    }

    public void setMaxOrderTakeaway(int maxOrderTakeaway) {
        this.maxOrderTakeaway = maxOrderTakeaway;
    }

    public int getMaxOrderSelf() {
        return maxOrderSelf;
    }

    public void setMaxOrderSelf(int maxOrderSelf) {
        this.maxOrderSelf = maxOrderSelf;
    }

    public int getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(int openStatus) {
        this.openStatus = openStatus;
    }

    public double getSumTotalAmount() {
        return sumTotalAmount;
    }

    public void setSumTotalAmount(double sumTotalAmount) {
        this.sumTotalAmount = sumTotalAmount;
    }

    public int getSumOrderNumber() {
        return sumOrderNumber;
    }

    public void setSumOrderNumber(int sumOrderNumber) {
        this.sumOrderNumber = sumOrderNumber;
    }

    public int getTakeawayOrderNumber() {
        return takeawayOrderNumber;
    }

    public void setTakeawayOrderNumber(int takeawayOrderNumber) {
        this.takeawayOrderNumber = takeawayOrderNumber;
    }

    public TakeOutSelfInfoBean getTakeoutType() {
        return takeoutType;
    }

    public void setTakeoutType(TakeOutSelfInfoBean takeoutType) {
        this.takeoutType = takeoutType;
    }

    public TakeOutSelfInfoBean getSelfCollectionType() {
        return selfCollectionType;
    }

    public void setSelfCollectionType(TakeOutSelfInfoBean selfCollectionType) {
        this.selfCollectionType = selfCollectionType;
    }

    public OrderAppointment getOrderAppointment() {
        return orderAppointment;
    }

    public void setOrderAppointment(OrderAppointment orderAppointment) {
        this.orderAppointment = orderAppointment;
    }
}
