package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.WareHousingDetailsModule;
import com.gingersoft.supply_chain.mvp.contract.WareHousingDetailsContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WareHousingDetailsFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/12/2021 14:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = WareHousingDetailsModule.class, dependencies = AppComponent.class)
public interface WareHousingDetailsComponent {
    void inject(WareHousingDetailsFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        WareHousingDetailsComponent.Builder view(WareHousingDetailsContract.View view);

        WareHousingDetailsComponent.Builder appComponent(AppComponent appComponent);

        WareHousingDetailsComponent build();
    }
}