package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.ConfirmOrderBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/18
 * Time: 16:00
 * Use:
 */
public class ConfirmOrderAdapter extends BaseQuickAdapter<ConfirmOrderBean, BaseViewHolder> {

    public ConfirmOrderAdapter() {
        super(R.layout.item_confirm_order);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder holder, ConfirmOrderBean confirmOrderBean) {
        ConfirmOrderBean.PurchaseOrder purchaseOrder = confirmOrderBean.getPurchaseOrder();

        holder.setText(R.id.tv_confirm_order_item_supplier_name, purchaseOrder.getSupplierName());
        holder.setText(R.id.tv_confirm_order_item_supplier_address, purchaseOrder.getSendingAddress());
        holder.setText(R.id.tv_confirm_order_item_send_time, TimeUtils.getStringByFormat(purchaseOrder.getInitialShippingTime(), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
        holder.setText(R.id.tv_confirm_order_item_total_amount, purchaseOrder.getTotalAmount() + "");
        holder.setText(R.id.tv_confirm_order_item_freight, purchaseOrder.getShipping() + "");
        holder.setText(R.id.tv_confirm_order_item_pay_amount, purchaseOrder.getActualPayment() + "");
        EditText editText = holder.getView(R.id.ed_confirm_order_item_remark);

        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                getData().get(holder.getAdapterPosition()).getPurchaseOrder().setRemarks(s + "");
            }
        });
    }
}