package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.view.View;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/8
 * Time: 16:19
 * Use:
 */
public class OrderCategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int selectIndex = -1;
    private Context context;
    private int lastSelectIndex = -1;

    public static final int PRIMARY_CATEGORY = 1;
    public static final int SECOND_CATEGORY = 2;
    /**
     * 當前顯示的是幾級分類
     */
    private int currentLevelCategory = PRIMARY_CATEGORY;

    public OrderCategoryAdapter(Context context, @Nullable List<OrderCategoryBean.FoodCategoryTrees> data) {
        super(R.layout.item_order_category, data);
        this.context = context;
        addChildClickViewIds(R.id.layout_order_category_back);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees foodCategoryTrees) {
        viewHolder.setText(R.id.tv_category_name, foodCategoryTrees.getName());
        viewHolder.setGone(R.id.order_primary_category_line, viewHolder.getAdapterPosition() == selectIndex);
        RecyclerView rvSecondCategory = viewHolder.getView(R.id.rv_order_second_category);
        CardView bgLayout = viewHolder.getView(R.id.layout_category);
        //是否顯示返回鍵
        if (viewHolder.getAdapterPosition() == 0) {
            viewHolder.setGone(R.id.layout_order_category_back, currentLevelCategory == PRIMARY_CATEGORY);
        } else {
            viewHolder.setGone(R.id.layout_order_category_back, true);
        }
        if (selectIndex == viewHolder.getAdapterPosition()) {
            //選中並且有子類
            if (foodCategoryTrees.getFoodCategoryTrees() != null && foodCategoryTrees.getFoodCategoryTrees().size() > 0) {
                viewHolder.setGone(R.id.order_primary_category_line, false);
                //設置子類的數據
                SecondAdapter secondAdapter = new SecondAdapter(context, foodCategoryTrees.getFoodCategoryTrees());
                rvSecondCategory.setAdapter(secondAdapter);
                rvSecondCategory.setVisibility(View.VISIBLE);
                secondAdapter.setOnItemClickListener((adapter, view, position) -> {
                    //二級分類被點擊時，重新設置一級的數據，二級變為一級，三級變成二級
                    secondAdapter.setSelectedIndex(position);
                    if (onSecondCategoryClickListener != null) {
                        onSecondCategoryClickListener.onClick(getData().get(viewHolder.getAdapterPosition()).getFoodCategoryTrees(), position);
                    }
                });
            } else {
                rvSecondCategory.setAdapter(null);
                viewHolder.setGone(R.id.order_primary_category_line, true);
            }
            viewHolder.setTextColor(R.id.tv_category_name, ContextCompat.getColor(context, R.color.order_category_name_select_color));
            bgLayout.setBackground(ContextCompat.getDrawable(context, R.drawable.shape_left_radio_shadow));
        } else {
            //隱藏豎線
            viewHolder.setGone(R.id.order_primary_category_line, true);
            viewHolder.setTextColor(R.id.tv_category_name, ContextCompat.getColor(context, R.color.order_category_name_unselect_color));
            //沒有被選中時，去掉背景，去掉子類
            bgLayout.setBackground(null);
            rvSecondCategory.setVisibility(View.GONE);
            rvSecondCategory.setAdapter(null);
        }
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        if (lastSelectIndex != -1 && lastSelectIndex < getData().size()) {
            notifyItemChanged(lastSelectIndex);
        }
        if (selectIndex != -1 && selectIndex < getData().size()) {
            notifyItemChanged(selectIndex);
        }
        lastSelectIndex = selectIndex;
    }

    public OnSecondCategoryClickListener onSecondCategoryClickListener;

    public interface OnSecondCategoryClickListener {
        void onClick(List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTrees, int position);
    }

    public void setOnSecondCategoryClickListener(OnSecondCategoryClickListener onSecondCategoryClickListener) {
        this.onSecondCategoryClickListener = onSecondCategoryClickListener;
    }

    public int getSelectIndex() {
        return selectIndex;
    }

    public int getCurrentLevelCategory() {
        return currentLevelCategory;
    }

    public void setCurrentLevelCategory(int currentLevelCategory) {
        this.currentLevelCategory = currentLevelCategory;
    }

    public static class SecondAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {
        private int selectedIndex = -1;
        private int lastSelectIndex = -1;
        private Context context;

        public SecondAdapter(Context context, @Nullable List<OrderCategoryBean.FoodCategoryTrees> data) {
            super(R.layout.item_order_second_category, data);
            this.context = context;
        }

        @Override
        protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees foodCategoryTrees) {
            viewHolder.setText(R.id.tv_order_second_category_name, foodCategoryTrees.getName());
            if (selectedIndex == viewHolder.getAdapterPosition()) {
                viewHolder.setTextColor(R.id.tv_order_second_category_name, ContextCompat.getColor(context, R.color.white));
                viewHolder.setBackgroundColor(R.id.layout_second_category, ContextCompat.getColor(context, R.color.theme_color));
            } else {
                viewHolder.setTextColor(R.id.tv_order_second_category_name, ContextCompat.getColor(context, R.color.order_category_name_unselect_color));
                viewHolder.setBackgroundColor(R.id.layout_second_category, ContextCompat.getColor(context, R.color.trans));
            }
            viewHolder.setVisible(R.id.order_category_second_bottom_line, viewHolder.getAdapterPosition() != getData().size() - 1);
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
            if (lastSelectIndex != -1 && lastSelectIndex < getData().size()) {
                notifyItemChanged(lastSelectIndex);
            }
            if (selectedIndex != -1 && selectedIndex < getData().size()) {
                notifyItemChanged(selectedIndex);
            }
            lastSelectIndex = selectedIndex;
        }
    }

}
