package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.util.Log;
import android.widget.RadioButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/19
 * Time: 18:01
 * Use:
 */
public class SupplierAdapter extends BaseQuickAdapter<SupplierInfoBean, BaseViewHolder> {

    private boolean isSelect;
    private int selectIndex = 0;

    public SupplierAdapter(@Nullable List<SupplierInfoBean> data) {
        this(data, false);
    }

    public SupplierAdapter(@Nullable List<SupplierInfoBean> data, boolean isSelect) {
        super(R.layout.item_supplier, data);
        addChildClickViewIds(R.id.iv_supplier_delete, R.id.layout_supplier_food_info);
        this.isSelect = isSelect;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, SupplierInfoBean supplierBean) {
        viewHolder.setText(R.id.tv_supplier_name, supplierBean.getSupplierName());
        viewHolder.setText(R.id.tv_supplier_address, supplierBean.getAddress());
        viewHolder.setText(R.id.tv_supplier_phone, supplierBean.getContactInformation());
        viewHolder.setText(R.id.tv_supplier_contact, supplierBean.getContacts());
        viewHolder.setText(R.id.tv_supplier_create_date, TimeUtils.getTime(supplierBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT) + "");
        viewHolder.setGone(R.id.rb_supplier, !isSelect);
        viewHolder.setGone(R.id.iv_supplier_edit, isSelect);
        viewHolder.setGone(R.id.iv_supplier_delete, isSelect);
        if(isSelect) {
            RadioButton radioButton = viewHolder.getView(R.id.rb_supplier);
            radioButton.setChecked(viewHolder.getAdapterPosition() == selectIndex);
            radioButton.setOnCheckedChangeListener((buttonView, isChecked) -> {
                if (isChecked) {
                    if (getRecyclerView().isComputingLayout()) {
                        getRecyclerView().post(() -> notifyData(viewHolder));
                    } else {
                        notifyData(viewHolder);
                    }
                }
            });
        }
    }

    private void notifyData(@NotNull BaseViewHolder viewHolder) {
        SupplierAdapter.this.notifyItemChanged(selectIndex);
        selectIndex = viewHolder.getAdapterPosition();
        SupplierAdapter.this.notifyItemChanged(selectIndex);
    }

    public int getSelectIndex() {
        return selectIndex;
    }
}
