package com.gingersoft.gsa.cloud.order.bean.request;

import com.gingersoft.gsa.cloud.pay.pos.bean.PosMatter;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-07-25
 * 修订历史：2020-07-25
 * 描述：堂食支付請求數據
 */
@Data
public class MealOrderPayRequest {

    private long orderId;
    private int linePayType;
    private int orderPayType;
    private int tableId;
    private String tableNumber;
    private Long memberId;
    private Long couponId;
    /**當前加的積分*/
    private Double pointsAdd;
    /**當前減去的積分*/
    private Double pointsUse;
    /**
     * 是否免服務費(0:否 1：是)
     */
    private int whetherFreeService;
    private List<OrderPay> orderPays = new ArrayList<>();

    /**
     * Pos支付狀態更新
     */
    private PosMatter posMatter;

    @Data
    public static class OrderPay {
        private int payType;
        private double amount;
        private double tipsPrice;
        /**積分支付 所消費的積分*/
        private Double consumptionPoints;
    }

}
