package com.gingersoft.gsa.cloud.ui.bean;

import com.qmuiteam.qmui.widget.section.QMUISection.Model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import lombok.Data;

/**
 * 選中
 */
@Data
public class SectionCheckItem implements Model<SectionCheckItem>, Serializable {
    private static final long serialVersionUID = 5714222336447667903L;
    private int id;
    private boolean isChecked = false;
    private String text;
    /**
     * 子類
     */
    private List<SectionCheckItem> sectionCheckItems;
    /**
     * 子類被選中的下標
     */
    private int checkIndex = -1;
    private int sort;

    public SectionCheckItem(int id, String text, int sort) {
        this.id = id;
        this.text = text;
        this.sort = sort;
    }

    public SectionCheckItem() {
    }

    public SectionCheckItem(int id, boolean isChecked, String text) {
        this.id = id;
        this.isChecked = isChecked;
        this.text = text;
    }

    @Override
    public SectionCheckItem cloneForDiff() {
        return new SectionCheckItem(getId(), getText(), getSort());
    }

    @Override
    public boolean isSameItem(SectionCheckItem other) {
        return Objects.equals(text, other.text);
    }

    @Override
    public boolean isSameContent(SectionCheckItem other) {
        return true;
    }
}
