package com.gingersoft.gsa.cloud.meal.mvp.model.service;

import com.gingersoft.gsa.cloud.base.bean.BaseRespose;
import com.gingersoft.gsa.cloud.meal.mvp.model.bean.request.OrderRequest;

import java.util.List;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-06
 * 修订历史：2020-01-06
 * 描述：
 */
public interface MealService {

    @POST("order/send" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> createOrder(@Body OrderRequest request);

    @POST("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> addFood(@Body OrderRequest request);

    @GET("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<Object> loadOrder(@Query("orderId") int orderId);

    @POST("orderDetails/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> deleteFood(@Body RequestBody requestBody);

    @POST("behavior/print" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> printOrder(@Body RequestBody requestBody);


}
