package com.gingersoft.gsa.cloud.meal.mvp.presenter;

import android.app.Activity;
import android.app.Application;

import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.meal.mvp.contract.BaseOrderContract;
import com.gingersoft.gsa.cloud.base.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.meal.mvp.ui.adapter.meal.SelectMealAdapter;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;

import java.util.List;

import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-11
 * 修订历史：2020-01-11
 * 描述：
 */

@ActivityScope
public class BaseOrderPresenter <M extends BaseOrderContract.Model, V extends BaseOrderContract.View> extends BasePresenter<BaseOrderContract.Model, BaseOrderContract.View> {

    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    protected M mModel;
    protected V mRootView;

    private Activity IActivity;

    //订单数据管理类
    protected MyOrderManage myOrderManage;

    protected SelectMealAdapter mSelectMealAdapter;


    @Inject
    public BaseOrderPresenter(BaseOrderContract.Model model, BaseOrderContract.View rootView) {
        super(model, rootView);
        this.mModel = (M) model;
        this.mRootView = (V) rootView;
        this.IActivity = (Activity) mRootView;

        this.myOrderManage = MyOrderManage.getInstance();

        initFoodAdapter();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    private void initFoodAdapter() {
        if (mSelectMealAdapter == null) {
            mSelectMealAdapter = new SelectMealAdapter(IActivity, myOrderManage.getOrderFoodList(), this);
        }
//        myOrderManage.setSelectMealAdapter(mSelectMealAdapter);
    }


    public double getTotal() {
        double total = 0.0;
        for (Food food : myOrderManage.getOrderFoodList()) {
            total += food.getNumber() * food.getPrice();
        }
        return total;
    }

    public int getFoodCout() {
        int cout = 0;
        for (Food food : myOrderManage.getOrderFoodList()) {
            cout += food.getNumber();
        }
        return cout;
    }

    public List<Food> getOrderFoodLists() {
        return myOrderManage.getOrderFoodList();
    }
}

