package com.joe.print;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;

import com.billy.cc.core.component.CCUtil;
import com.gingersoft.gsa.cloud.base.bean.TableBean;
import com.gingersoft.gsa.cloud.base.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.mealManage.OpenTableContract;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.ui.dialog.LoadingDialog;
import com.joe.print.adapter.BillAdapter;
import com.joe.print.adapter.FoodAdapter;
import com.joe.print.bean.BillingBean;
import com.joe.print.bean.FoodBean;
import com.joe.print.print.SendPrint;

import java.util.ArrayList;
import java.util.List;

import am.util.printer.PrintExecutor;
import am.util.printer.PrintSocketHolder;
import am.util.printer.PrinterWriter58mm;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by Wyh on 2020/1/7.
 */
public class PrintActivity extends Activity implements PrintSocketHolder.OnStateChangedListener, PrintExecutor.OnPrintResultListener {

    private ImageView view;

    private PrintExecutor executor;
    private SendPrint maker;

    private TextView tv_dining_table_number;
    private TextView tv_people;
    private TextView tv_order_num;
    private TextView tv_date;

    private RecyclerView rvFood;
    private RecyclerView rvBill;



    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_print);
        setContentView(R.layout.print_layout_print);

        tv_dining_table_number= findViewById(R.id.tv_dining_table_number);
        tv_people= findViewById(R.id.tv_people);
        tv_order_num= findViewById(R.id.tv_order_num);
        tv_date= findViewById(R.id.tv_date);

        rvFood = findViewById(R.id.rv_food);
        rvBill = findViewById(R.id.rv_bill_amount);

        List<Food> foodList = MyOrderManage.getInstance().getOrderFoodList();
        TableBean.DataBean tableBean = OpenTableContract.getDefault().getTableBean();

        tv_dining_table_number.setText(tableBean.getTableName());
        tv_people.setText(tableBean.getPeopleNumber()+"");
//        tv_order_num.setText();
        tv_date.setText(tableBean.getCreateTime());

//        List<FoodBean> data = new ArrayList<>();
//        data.add(new FoodBean("包子（主項）", 1, 13.54));
//        data.add(new FoodBean("番薯爸爸", 2, 8.0));
//        data.add(new FoodBean("包子（主項）", 3, 37.34));
//        data.add(new FoodBean("測卡很快就酸辣粉十大減肥和思考", 33, 1334.2254));

        FoodAdapter foodAdapter = new FoodAdapter(foodList);
        rvFood.setLayoutManager(new LinearLayoutManager(this));
        rvFood.setAdapter(foodAdapter);

        List<BillingBean> billingBeans = new ArrayList<>();
        billingBeans.add(new BillingBean("合計", 58.88));
        billingBeans.add(new BillingBean("10%服務費", 5.08));
        billingBeans.add(new BillingBean("賬單小數", -0.06));
        billingBeans.add(new BillingBean("上課交電話費扣水電費可接受的咖啡機", 837248.8829372));

        BillAdapter billAdapter = new BillAdapter(billingBeans);
        rvBill.setLayoutManager(new LinearLayoutManager(this));
        rvBill.setAdapter(billAdapter);

//        view = findViewById(R.id.iv_print);

        LoadingDialog.showDialogForLoading(this,"打印中...",false);

        //        findViewById(R.id.btn_print).setOnClickListener(v -> {
        if (executor == null) {
            executor = new PrintExecutor("192.168.1.217", 9100, PrinterWriter58mm.TYPE_58);
            executor.setOnStateChangedListener(PrintActivity.this::onResult);
            executor.setOnPrintResultListener(PrintActivity.this);
        }
        executor.setIp("192.168.1.217", 9100);
        executor.doPrinterRequestAsync(maker);
//        });
    }

    public void loadImage(Bitmap bitmap) {
        runOnUiThread(() -> view.setImageBitmap(bitmap));
    }

    @Override
    public void onResult(int errorCode) {
        switch (errorCode) {
            case PrintSocketHolder.ERROR_0:
                break;
            case PrintSocketHolder.ERROR_1:
                break;
            case PrintSocketHolder.ERROR_2:
                break;
            case PrintSocketHolder.ERROR_3:
                break;
            case PrintSocketHolder.ERROR_4:
                break;
            case PrintSocketHolder.ERROR_5:
                break;
        }
        LoadingDialog.cancelDialogForLoading();
        finish();
    }

    @Override
    public void onStateChanged(int state) {
        switch (state) {
            case PrintSocketHolder.STATE_0:
                break;
            case PrintSocketHolder.STATE_1:
                break;
            case PrintSocketHolder.STATE_2:
                break;
            case PrintSocketHolder.STATE_3:
                break;
            case PrintSocketHolder.STATE_4:
                break;
        }
    }


}
