package com.gingersoft.gsa.cloud.meal.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.bean.BaseRespose;
import com.gingersoft.gsa.cloud.meal.mvp.model.bean.request.OrderRequest;
import com.gingersoft.gsa.cloud.meal.mvp.model.service.MealService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.meal.mvp.contract.OrderContentContract;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderContentModel extends BaseModel implements OrderContentContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderContentModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseRespose> createOrder(OrderRequest request) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(request);
    }

    @Override
    public Observable<BaseRespose> addFood(OrderRequest request) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .addFood(request);
    }

    @Override
    public Observable<BaseRespose> printOrder(RequestBody request) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .printOrder(request);
    }
}