package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property ParentId = new Property(1, int.class, "parentId", false, "PARENT_ID");
        public final static Property FoodName = new Property(2, String.class, "foodName", false, "FOOD_NAME");
        public final static Property RestaurantId = new Property(3, int.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Price = new Property(4, double.class, "price", false, "PRICE");
        public final static Property TotalSold = new Property(5, int.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(6, int.class, "isSold", false, "IS_SOLD");
        public final static Property Plu = new Property(7, String.class, "plu", false, "PLU");
    }


    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"PARENT_ID\" INTEGER NOT NULL ," + // 1: parentId
                "\"FOOD_NAME\" TEXT," + // 2: foodName
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 3: restaurantId
                "\"PRICE\" REAL NOT NULL ," + // 4: price
                "\"TOTAL_SOLD\" INTEGER NOT NULL ," + // 5: totalSold
                "\"IS_SOLD\" INTEGER NOT NULL ," + // 6: isSold
                "\"PLU\" TEXT);"); // 7: plu
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getParentId());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(3, foodName);
        }
        stmt.bindLong(4, entity.getRestaurantId());
        stmt.bindDouble(5, entity.getPrice());
        stmt.bindLong(6, entity.getTotalSold());
        stmt.bindLong(7, entity.getIsSold());
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(8, plu);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getParentId());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(3, foodName);
        }
        stmt.bindLong(4, entity.getRestaurantId());
        stmt.bindDouble(5, entity.getPrice());
        stmt.bindLong(6, entity.getTotalSold());
        stmt.bindLong(7, entity.getIsSold());
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(8, plu);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getInt(offset + 1), // parentId
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // foodName
            cursor.getInt(offset + 3), // restaurantId
            cursor.getDouble(offset + 4), // price
            cursor.getInt(offset + 5), // totalSold
            cursor.getInt(offset + 6), // isSold
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7) // plu
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setParentId(cursor.getInt(offset + 1));
        entity.setFoodName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRestaurantId(cursor.getInt(offset + 3));
        entity.setPrice(cursor.getDouble(offset + 4));
        entity.setTotalSold(cursor.getInt(offset + 5));
        entity.setIsSold(cursor.getInt(offset + 6));
        entity.setPlu(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
