/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposprint;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.epson.eposprint.BatteryLowEventListener;
import com.epson.eposprint.BatteryOkEventListener;
import com.epson.eposprint.BatteryStatusChangeEventListener;
import com.epson.eposprint.Builder;
import com.epson.eposprint.CoverOkEventListener;
import com.epson.eposprint.CoverOpenEventListener;
import com.epson.eposprint.DrawerClosedEventListener;
import com.epson.eposprint.DrawerOpenEventListener;
import com.epson.eposprint.EposException;
import com.epson.eposprint.OfflineEventListener;
import com.epson.eposprint.OnlineEventListener;
import com.epson.eposprint.PaperEndEventListener;
import com.epson.eposprint.PaperNearEndEventListener;
import com.epson.eposprint.PaperOkEventListener;
import com.epson.eposprint.PowerOffEventListener;
import com.epson.eposprint.StatusChangeEventListener;
import com.epson.epsonio.SupportUsb;
import java.io.File;

public class Print {
    private long mPrinterHandle = 0L;
    private Context mContext = null;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_UNSPECIFIED = -1;
    public static final int PARAM_DEFAULT = -2;
    public static final int ST_NO_RESPONSE = 1;
    public static final int ST_PRINT_SUCCESS = 2;
    public static final int ST_DRAWER_KICK = 4;
    public static final int ST_BATTERY_OFFLINE = 4;
    public static final int ST_OFF_LINE = 8;
    public static final int ST_COVER_OPEN = 32;
    public static final int ST_PAPER_FEED = 64;
    public static final int ST_WAIT_ON_LINE = 256;
    public static final int ST_PANEL_SWITCH = 512;
    public static final int ST_MECHANICAL_ERR = 1024;
    public static final int ST_AUTOCUTTER_ERR = 2048;
    public static final int ST_UNRECOVER_ERR = 8192;
    public static final int ST_AUTORECOVER_ERR = 16384;
    public static final int ST_RECEIPT_NEAR_END = 131072;
    public static final int ST_RECEIPT_END = 524288;
    public static final int ST_BUZZER = 0x1000000;
    public static final int ST_HEAD_OVERHEAT = 0x10000000;
    public static final int ST_MOTOR_OVERHEAT = 0x20000000;
    public static final int ST_BATTERY_OVERHEAT = 0x40000000;
    public static final int ST_WRONG_PAPER = 4096;
    public static final int DEVTYPE_TCP = 0;
    public static final int DEVTYPE_BLUETOOTH = 1;
    public static final int DEVTYPE_USB = 2;
    private StatusChangeEventListener mStatusChangeEventListener;
    private OnlineEventListener mOnlineEventListener;
    private OfflineEventListener mOfflineEventListener;
    private PowerOffEventListener mPowerOffEventListener;
    private CoverOkEventListener mCoverOkEventListener;
    private CoverOpenEventListener mCoverOpenEventListener;
    private PaperOkEventListener mPaperOkEventListener;
    private PaperNearEndEventListener mPaperNearEndEventListener;
    private PaperEndEventListener mPaperEndEventListener;
    private DrawerClosedEventListener mDrawerClosedEventListener;
    private DrawerOpenEventListener mDrawerOpenEventListener;
    private BatteryLowEventListener mBatteryLowEventListener;
    private BatteryOkEventListener mBatteryOkEventListener;
    private BatteryStatusChangeEventListener mBatteryStatusChangeEventListener;
    private static final int ON_STATUS_CHANGE = 0;
    private static final int ON_ONLINE = 1;
    private static final int ON_OFFLINE = 2;
    private static final int ON_POWER_OFF = 3;
    private static final int ON_COVER_OK = 4;
    private static final int ON_COVER_OPEN = 5;
    private static final int ON_PAPER_OK = 6;
    private static final int ON_PAPER_NEAR_END = 7;
    private static final int ON_PAPER_END = 8;
    private static final int ON_DRAWER_CLOSED = 9;
    private static final int ON_DRAWER_OPEN = 10;
    private static final int ON_BATTERY_LOW = 11;
    private static final int ON_BATTERY_OK = 12;
    private static final int ON_BATTERY_STATUS_CHANGE = 13;

    private native int eposOpenPrinter(long[] var1, int var2, String var3, int var4, int var5, Object var6, int var7, boolean var8);

    private native int eposClosePrinter(long var1);

    private native int eposBeginTransaction(long var1);

    private native int eposEndTransaction(long var1);

    private native int eposSendData(long var1, long var3, int var5, int[] var6, int[] var7);

    private native void eposSetEventCallback(long var1);

    private native void eposSetAVDInfo();

    private native int eposSetDBFilePath(String var1);

    private native int eposReadLogSettings(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    private native int eposEventLog(String var1, String var2, int var3);

    private native int eposEventLog(String var1, String var2, int var3, int var4, int var5);

    private native int eposGetStatus(long var1, int[] var3, int[] var4);

    private void onStatusChange(String deviceName, int status) {
        if (null != this.mStatusChangeEventListener) {
            this.mStatusChangeEventListener.onStatusChangeEvent(deviceName, status);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mStatusChangeEventListener.hashCode()), 0, 1, status);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onOnline(String deviceName) {
        if (null != this.mOnlineEventListener) {
            this.mOnlineEventListener.onOnlineEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mOnlineEventListener.hashCode()), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onOffline(String deviceName) {
        if (null != this.mOfflineEventListener) {
            this.mOfflineEventListener.onOfflineEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mOfflineEventListener.hashCode()), 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onPowerOff(String deviceName) {
        if (null != this.mPowerOffEventListener) {
            this.mPowerOffEventListener.onPowerOffEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mPowerOffEventListener.hashCode()), 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onCoverOk(String deviceName) {
        if (null != this.mCoverOkEventListener) {
            this.mCoverOkEventListener.onCoverOkEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mCoverOkEventListener.hashCode()), 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onCoverOpen(String deviceName) {
        if (null != this.mCoverOpenEventListener) {
            this.mCoverOpenEventListener.onCoverOpenEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mCoverOpenEventListener.hashCode()), 5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onPaperOk(String deviceName) {
        if (null != this.mPaperOkEventListener) {
            this.mPaperOkEventListener.onPaperOkEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mPaperOkEventListener.hashCode()), 6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onPaperNearEnd(String deviceName) {
        if (null != this.mPaperNearEndEventListener) {
            this.mPaperNearEndEventListener.onPaperNearEndEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mPaperNearEndEventListener.hashCode()), 7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onPaperEnd(String deviceName) {
        if (null != this.mPaperEndEventListener) {
            this.mPaperEndEventListener.onPaperEndEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mPaperEndEventListener.hashCode()), 8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onDrawerClosed(String deviceName) {
        if (null != this.mDrawerClosedEventListener) {
            this.mDrawerClosedEventListener.onDrawerClosedEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mDrawerClosedEventListener.hashCode()), 9);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onDrawerOpen(String deviceName) {
        if (null != this.mDrawerOpenEventListener) {
            this.mDrawerOpenEventListener.onDrawerOpenEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mDrawerOpenEventListener.hashCode()), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onBatteryLow(String deviceName) {
        if (null != this.mBatteryLowEventListener) {
            this.mBatteryLowEventListener.onBatteryLowEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mBatteryLowEventListener.hashCode()), 11);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onBatteryOk(String deviceName) {
        if (null != this.mBatteryOkEventListener) {
            this.mBatteryOkEventListener.onBatteryOkEvent(deviceName);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mBatteryOkEventListener.hashCode()), 12);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onBatteryStatusChange(String deviceName, int battery) {
        if (null != this.mBatteryStatusChangeEventListener) {
            this.mBatteryStatusChangeEventListener.onBatteryStatusChangeEvent(deviceName, battery);
            try {
                this.eposEventLog(deviceName, Integer.toHexString(this.mBatteryStatusChangeEventListener.hashCode()), 13, 1, battery);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Print() {
        boolean isAVD;
        boolean bl = isAVD = TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"google_sdk") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk_phone_armv7") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk_google_phone_armv7");
        if (isAVD) {
            this.eposSetAVDInfo();
        }
    }

    public Print(Context context) {
        this();
        String path = "";
        if (null != context) {
            try {
                path = context.getExternalFilesDir(null).toString();
            }
            catch (Exception e) {
                path = "";
            }
        }
        String sdkName = "ePOS-Print SDK for Android";
        String sdkVer = "1.9.0";
        String deviceOs = "Android";
        String deviceOsVer = Build.VERSION.RELEASE;
        String deviceName = Build.MODEL;
        long totalRamSize = Print.getTotalMemorySize(Environment.getDataDirectory());
        long freeRamSize = Print.getFreeMemorySize(Environment.getDataDirectory());
        long freeStorageSize = Print.getFreeMemorySize(Environment.getExternalStorageDirectory());
        String ramSize = String.format("%d/%d", freeRamSize, totalRamSize);
        String storageSize = String.format("%d", freeStorageSize);
        boolean isAVD = TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"google_sdk") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk_phone_armv7") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk_google_phone_armv7");
        try {
            this.eposReadLogSettings(path, sdkName, sdkVer, deviceOs, deviceOsVer, deviceName, ramSize, storageSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mContext = context;
        if (isAVD) {
            this.eposSetAVDInfo();
        }
        try {
            this.eposSetDBFilePath(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (0L != this.mPrinterHandle) {
                this.eposClosePrinter(this.mPrinterHandle);
                this.mPrinterHandle = 0L;
            }
        }
    }

    public void openPrinter(int deviceType, String deviceName) throws EposException {
        this.openPrinter(deviceType, deviceName, -2, -2);
    }

    public void openPrinter(int deviceType, String deviceName, int enabled, int interval) throws EposException {
        try {
            this.openPrinter(deviceType, deviceName, enabled, interval, -2);
        }
        catch (EposException e) {
            if (e.getErrorStatus() == 4) {
                throw new EposException(2);
            }
            throw new EposException(e.getErrorStatus());
        }
    }

    public void openPrinter(int deviceType, String deviceName, int enabled, int interval, int timeout) throws EposException {
        if (null == deviceName) {
            throw new EposException(1);
        }
        if (0L != this.mPrinterHandle) {
            throw new EposException(6);
        }
        if (2 == deviceType) {
            if (!SupportUsb.isSupport().booleanValue()) {
                throw new EposException(1);
            }
            if (this.mContext == null) {
                throw new EposException(6);
            }
        }
        long[] pPrinterHandle = new long[]{0L};
        int errStatus = this.eposOpenPrinter(pPrinterHandle, deviceType, deviceName, enabled, interval, this.mContext, timeout, true);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
        this.mPrinterHandle = pPrinterHandle[0];
    }

    public void closePrinter() throws EposException {
        if (0L == this.mPrinterHandle) {
            throw new EposException(6);
        }
        int errStatus = this.eposClosePrinter(this.mPrinterHandle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
        this.mPrinterHandle = 0L;
    }

    public void beginTransaction() throws EposException {
        if (0L == this.mPrinterHandle) {
            throw new EposException(6);
        }
        int errStatus = this.eposBeginTransaction(this.mPrinterHandle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void endTransaction() throws EposException {
        if (0L == this.mPrinterHandle) {
            throw new EposException(6);
        }
        int errStatus = this.eposEndTransaction(this.mPrinterHandle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void sendData(Builder builder, int timeout, int[] status) throws EposException {
        int[] battery = new int[]{0};
        this.sendData(builder, timeout, status, battery);
    }

    public void sendData(Builder builder, int timeout, int[] status, int[] battery) throws EposException {
        if (null == builder) {
            throw new EposException(1);
        }
        if (null == status || 0 == status.length) {
            throw new EposException(1);
        }
        if (null == battery || 0 == battery.length) {
            throw new EposException(1);
        }
        if (0L == this.mPrinterHandle) {
            throw new EposException(6);
        }
        int errStatus = this.eposSendData(this.mPrinterHandle, builder.getHandle(), timeout, status, battery);
        if (0 != errStatus) {
            throw new EposException(errStatus, status[0]);
        }
    }

    public void getStatus(int[] status, int[] battery) throws EposException {
        if (null == status || 0 == status.length) {
            throw new EposException(1);
        }
        if (null == battery || 0 == battery.length) {
            throw new EposException(1);
        }
        if (0L == this.mPrinterHandle) {
            throw new EposException(6);
        }
        int errStatus = this.eposGetStatus(this.mPrinterHandle, status, battery);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void setStatusChangeEventCallback(StatusChangeEventListener statusChangeEventListener) {
        this.mStatusChangeEventListener = statusChangeEventListener;
    }

    public void setOnlineEventCallback(OnlineEventListener onlineEventListener) {
        this.mOnlineEventListener = onlineEventListener;
    }

    public void setOfflineEventCallback(OfflineEventListener offlineEventListener) {
        this.mOfflineEventListener = offlineEventListener;
    }

    public void setPowerOffEventCallback(PowerOffEventListener powerOffEventListener) {
        this.mPowerOffEventListener = powerOffEventListener;
    }

    public void setCoverOkEventCallback(CoverOkEventListener coverOkEventListener) {
        this.mCoverOkEventListener = coverOkEventListener;
    }

    public void setCoverOpenEventCallback(CoverOpenEventListener coverOpenEventListener) {
        this.mCoverOpenEventListener = coverOpenEventListener;
    }

    public void setPaperOkEventCallback(PaperOkEventListener paperOkEventListener) {
        this.mPaperOkEventListener = paperOkEventListener;
    }

    public void setPaperNearEndEventCallback(PaperNearEndEventListener paperNearEndEventListener) {
        this.mPaperNearEndEventListener = paperNearEndEventListener;
    }

    public void setPaperEndEventCallback(PaperEndEventListener paperEndEventListener) {
        this.mPaperEndEventListener = paperEndEventListener;
    }

    public void setDrawerClosedEventCallback(DrawerClosedEventListener drawerClosedEventListener) {
        this.mDrawerClosedEventListener = drawerClosedEventListener;
    }

    public void setDrawerOpenEventCallback(DrawerOpenEventListener drawerOpenEventListener) {
        this.mDrawerOpenEventListener = drawerOpenEventListener;
    }

    public void setBatteryLowEventCallback(BatteryLowEventListener batteryLowEventListener) {
        this.mBatteryLowEventListener = batteryLowEventListener;
    }

    public void setBatteryOkEventCallback(BatteryOkEventListener batteryOkEventListener) {
        this.mBatteryOkEventListener = batteryOkEventListener;
    }

    public void setBatteryStatusChangeEventCallback(BatteryStatusChangeEventListener batteryStatusChangeEventListener) {
        this.mBatteryStatusChangeEventListener = batteryStatusChangeEventListener;
    }

    private static long getTotalMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getTotalSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    private static long getFreeMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getFreeSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

