package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.SnCodeListModule;
import com.gingersoft.supply_chain.mvp.contract.SnCodeListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.SnCodeListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/26/2021 19:26
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = SnCodeListModule.class, dependencies = AppComponent.class)
public interface SnCodeListComponent {
    void inject(SnCodeListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        SnCodeListComponent.Builder view(SnCodeListContract.View view);

        SnCodeListComponent.Builder appComponent(AppComponent appComponent);

        SnCodeListComponent build();
    }
}