package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderDetailsBean;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/22/2020 16:57
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface OrderDetailsContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadOrderDetails(PurchaseOrderDetailsBean orderDetailsBean);

        void uploadPicSuccess(String imgUrl);

        void buyAgain();

        void querySnCodeSuccess(int position, PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean infoVosBean);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<BaseResult> getOrderDetails(int orderId);

        /**
         * 入庫
         */
        Observable<BaseResult> addWarehouse(RequestBody requestBody);

        Observable<BaseResult> upLoadPic(List<MultipartBody.Part> parts, Map<String, Object> map);

        Observable<BaseResult> deleteOrder(int orderId);

        /**
         * 查詢食品sn碼
         * @param encodeFoodNo 食品編號
         * @param encodeOrderNo 訂單編號
         */
        Observable<BaseResult> querySnCodes(String encodeFoodNo, String encodeOrderNo);
        /**
         * 再來一單
         * @param map
         * @return
         */
        Observable<BaseResult> buyAgainByFoodIds(Map<String, Object> map);
    }
}
