package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.text.Editable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;
import com.gingersoft.gsa.cloud.ui.view.section.QDSectionHeaderView;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.google.android.material.textfield.TextInputEditText;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/11
 * Time: 16:18
 * Use: 食材列表
 */
public class BuyIngredientsAdapter extends QMUIDefaultStickySectionAdapter<CategoryBean, PurchaseFoodBean> {

    private Context context;
    private boolean isSinger = true;

    public BuyIngredientsAdapter(Context context, List<QMUISection<CategoryBean, PurchaseFoodBean>> food) {
        this.context = context;
        setData(food);
    }


    @NonNull
    @Override
    protected HeadViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        return new HeadViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_buy_food_ingredient_header, viewGroup, false));
    }

    public int getLayoutId() {
        if (isSinger) {
            return R.layout.item_buy_food_ingredient;
        }
        return R.layout.item_buy_food_ingredient_double_row;
    }

    public void setShowSingerRow(boolean showType) {
        isSinger = showType;
    }

    @NonNull
    @Override
    protected ItemViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        return new ItemViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(getLayoutId(), viewGroup, false));
    }


    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<CategoryBean, PurchaseFoodBean> section) {
        super.onBindSectionHeader(holder, position, section);
        HeadViewHolder headViewHolder = (HeadViewHolder) holder;
        headViewHolder.tvHeader.setText(section.getHeader().getCategoryName());
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<CategoryBean, PurchaseFoodBean> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ItemViewHolder itemViewHolder = (ItemViewHolder) holder;
        PurchaseFoodBean purchaseFoodBean = section.getItemList().get(itemIndex);

        itemViewHolder.tvSupplierName.setText(purchaseFoodBean.getSupplierName());
        itemViewHolder.ivFoodIngredientImg.setImageResource(R.drawable.img_small_default);
        if (TextUtil.isNotEmptyOrNullOrUndefined(purchaseFoodBean.getImages())) {
            GlideUtils.display(itemViewHolder.ivFoodIngredientImg.getContext(), itemViewHolder.ivFoodIngredientImg, purchaseFoodBean.getImages());
        }
        itemViewHolder.tvFoodItemNo.setText(purchaseFoodBean.getFoodNo());
        itemViewHolder.tvFoodItemName.setText(purchaseFoodBean.getName());
        //如果有包裝描述就顯示包裝描述，沒有包裝描述顯示基本單位
        if (TextUtil.isNotEmptyOrNullOrUndefined(purchaseFoodBean.getPackingDescription())) {
            itemViewHolder.tvFoodItemUnit.setText(purchaseFoodBean.getPackingDescription());
        } else {
            itemViewHolder.tvFoodItemUnit.setText(purchaseFoodBean.getBasicUnitName());
        }
        itemViewHolder.tvFoodItemPrice.setText(String.format(context.getString(R.string.amount_string), purchaseFoodBean.getUnitPrice()));
        itemViewHolder.edFoodIngredientNumber.setText(String.valueOf(purchaseFoodBean.getFoodQuantity()), TextView.BufferType.EDITABLE);

        //如果數量小於等於0，就不顯示減號和數量
        setSubAndNumShow(itemViewHolder, purchaseFoodBean.getFoodQuantity() <= 0);
        //編輯數量
        itemViewHolder.btnFoodOperationSub.setOnClickListener(v -> {
            //食材數量減少
            if (purchaseFoodBean.getFoodQuantity() > 0) {
                purchaseFoodBean.setFoodQuantity(purchaseFoodBean.getFoodQuantity() - 1);
                itemViewHolder.edFoodIngredientNumber.setText(String.valueOf(purchaseFoodBean.getFoodQuantity()));
            }
            setSubAndNumShow(itemViewHolder, purchaseFoodBean.getFoodQuantity() <= 0);
        });
        itemViewHolder.btnFoodOperationAdd.setOnClickListener(v -> {
            //食材數量增加
            purchaseFoodBean.setFoodQuantity(purchaseFoodBean.getFoodQuantity() + 1);
            itemViewHolder.edFoodIngredientNumber.setText(String.valueOf(purchaseFoodBean.getFoodQuantity()));
            setSubAndNumShow(itemViewHolder, false);
        });
        //輸入框焦點監聽
        itemViewHolder.edFoodIngredientNumber.setOnFocusChangeListener((v, hasFocus) -> {
            Editable text = itemViewHolder.edFoodIngredientNumber.getText();
            if (!hasFocus) {
                //當失去焦點時，如果沒有食品數量了，就隱藏減號和輸入框
                if (TextUtil.isEmptyOrNullOrUndefined(text) || Integer.parseInt(text.toString()) == 0) {
                    setSubAndNumShow(itemViewHolder, false);
                }
            }
        });
    }

    /**
     * 設置減少按鈕和輸入框的顯示或隱藏
     *
     * @param showOrHide 顯示或隱藏
     */
    private void setSubAndNumShow(ItemViewHolder itemViewHolder, boolean showOrHide) {
        itemViewHolder.btnFoodOperationSub.setVisibility(showOrHide ? View.GONE : View.VISIBLE);
        itemViewHolder.edFoodIngredientNumber.setVisibility(showOrHide ? View.INVISIBLE : View.VISIBLE);
    }

    public static class HeadViewHolder extends QMUIStickySectionAdapter.ViewHolder {
        @BindView(R2.id.tv_buy_food_header)
        QMUIAlphaTextView tvHeader;

        public HeadViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }
    }

    public static class ItemViewHolder extends QMUIStickySectionAdapter.ViewHolder {
        @BindView(R2.id.iv_food_ingredient_img)
        ImageView ivFoodIngredientImg;
        @BindView(R2.id.tv_food_item_no)
        TextView tvFoodItemNo;
        @BindView(R2.id.tv_food_item_supplier_name)
        TextView tvSupplierName;
        @BindView(R2.id.tv_food_item_name)
        TextView tvFoodItemName;
        @BindView(R2.id.tv_food_item_unit)
        TextView tvFoodItemUnit;
        @BindView(R2.id.tv_food_item_price)
        TextView tvFoodItemPrice;
        @BindView(R2.id.btn_food_operation_sub)
        QMUIButton btnFoodOperationSub;
        @BindView(R2.id.ed_food_ingredient_number)
        TextInputEditText edFoodIngredientNumber;
        @BindView(R2.id.btn_food_operation_add)
        QMUIButton btnFoodOperationAdd;

        public ItemViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }
    }
}
