package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerSnCodeListComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;
import com.gingersoft.supply_chain.mvp.contract.SnCodeListContract;
import com.gingersoft.supply_chain.mvp.presenter.SnCodeListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.SnCodesAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import org.w3c.dom.Text;

import java.io.Serializable;
import java.util.List;

import butterknife.BindView;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/26/2021 19:26
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SnCodeListFragment extends BaseSupplyChainFragment<SnCodeListPresenter> implements SnCodeListContract.View {

    final static String FOOD_NAME_KEY = "FoodNameKey";
    final static String REMARK_KEY = "RemarkKey";
    final static String SN_KEY = "snKey";
    final static String HOUSING_NUM_KEY = "housingNumKey";
    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.tv_remark)
    TextView tvRemark;
    @BindView(R2.id.rv_sn)
    RecyclerView rvSn;
    @BindView(R2.id.tv_sn_housing_num)
    TextView tvHousingNum;

    public static SnCodeListFragment newInstance(String foodName, String remarks, int housingNum, List<PurchaseFoodEncodeSn> sns) {
        SnCodeListFragment fragment = new SnCodeListFragment();
        Bundle bundle = new Bundle();
        bundle.putString(FOOD_NAME_KEY, foodName);
        bundle.putSerializable(SN_KEY, (Serializable) sns);
        bundle.putString(REMARK_KEY, remarks);
        bundle.putInt(HOUSING_NUM_KEY, housingNum);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSnCodeListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_sn_code_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            initTopBar(supplyTopBar, arguments.getString(FOOD_NAME_KEY));
            int housingNum = arguments.getInt(HOUSING_NUM_KEY, 0);
            if (housingNum > 0) {
                tvHousingNum.setText("+" + housingNum);
            } else {
                tvHousingNum.setText(String.valueOf(housingNum));
            }
            tvRemark.setText(String.format(getString(R.string.str_format_remark), arguments.getString(REMARK_KEY)));
            List<PurchaseFoodEncodeSn> sns = (List<PurchaseFoodEncodeSn>) arguments.getSerializable(SN_KEY);
            SnCodesAdapter adapter = new SnCodesAdapter(sns);
            rvSn.setAdapter(adapter);
        } else {
            showMessage("獲取數據失敗");
            killMyself();
        }
    }
}
