package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.ui.adapter.SecondCategoryAdapter;
import com.google.android.flexbox.FlexWrap;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.lxj.xpopup.core.AttachPopupView;

import java.util.List;

import lombok.val;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/11
 * Time: 11:37
 * Use:
 */
public class ShowSecondCategoryPopup extends AttachPopupView {


    private final int width;
    private final List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTreesList;
    private final OnItemClickListener onItemClickListener;
    private final int defaultSelect;
    /**
     * 當前是否是顯示三級分類
     */
    private boolean showThirdCategory = false;

    public ShowSecondCategoryPopup(@NonNull Context context, int width, int defaultSelect, List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTreesList, OnItemClickListener onItemClickListener) {
        super(context);
        this.width = width;
        this.defaultSelect = defaultSelect;
        this.foodCategoryTreesList = foodCategoryTreesList;
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout.layout_popup_category_recycler;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        RecyclerView recyclerView = findViewById(R.id.rv_purchase_list_content);
        FlexboxLayoutManager flexboxLayoutManager = new FlexboxLayoutManager(getContext());
        flexboxLayoutManager.setFlexWrap(FlexWrap.WRAP);
        recyclerView.setLayoutManager(flexboxLayoutManager);
        SecondCategoryAdapter secondCategoryAdapter = new SecondCategoryAdapter(getContext(), foodCategoryTreesList);
        secondCategoryAdapter.setSelectedIndex(defaultSelect);
        secondCategoryAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (!showThirdCategory) {
                //三級分類就不回調
                onItemClickListener.onItemClick(adapter, view, position);
                val foodCategoryTrees = foodCategoryTreesList.get(position).getFoodCategoryTrees();
                //有三級分類就顯示三級分類，沒有三級分類，關閉彈窗，食材列表定位到所選中的二級分類
                if (foodCategoryTrees != null && foodCategoryTrees.size() > 0) {
                    //顯示三級分類
                    showThirdCategory = true;
                    secondCategoryAdapter.setNewInstance(foodCategoryTreesList.get(position).getFoodCategoryTrees());
                } else {
                    //關閉彈窗，食材列表清空，第一條顯示當前分類

                }
            } else {
                //當前是三級分類點擊，彈窗關閉，食材列表清空，第一條顯示當前分類

            }

        });
        recyclerView.setAdapter(secondCategoryAdapter);
    }

    @Override
    public int getMinimumWidth() {
        return width;
    }

    @Override
    protected int getMaxWidth() {
        return width;
    }
}
