package com.gingersoft.gsa.cloud.table.mvp.model.utils;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : bin
 * @create date: 2020-11-04
 * @update date: 2020-11-04
 * @description:餐牌相關數據條件過濾
 */
public class MealConditionFilterUtils {

    /**
     * 過濾食品條件
     *
     * @param foodList
     * @param summary
     * @return
     */
    public static List<Food> foodConditionFilter(List<Food> foodList, int summary) {
        List<Food> newFoodList = new ArrayList<>();
        if (foodList == null || foodList.size() > 0) {
            String strSummary = String.valueOf(summary);
            for (Food food : foodList) {
                String foodSummary = food.getFoodSummary();
                if (!TextUtils.isEmpty(foodSummary)) {
                    String[] summarys = foodSummary.split(",");
                    for (String item : summarys) {
                        if (item.equals(strSummary)) {
                            newFoodList.add(food);
                        }
                    }
                }
            }
        }
        return newFoodList;
    }

    /**
     * 過濾套餐食品條件
     *
     * @param comboItemList
     * @param summary
     * @return
     */
    public static List<ComboItem> comboConditionFilter(List<ComboItem> comboItemList, int summary) {
        List<ComboItem> newComboItemList = new ArrayList<>();
        if (newComboItemList == null || newComboItemList.size() > 0) {
            String strSummary = String.valueOf(summary);
            for (ComboItem comboItem : comboItemList) {
                String foodSummary = comboItem.getFoodSummary();
                if (!TextUtils.isEmpty(foodSummary)) {
                    String[] summarys = foodSummary.split(",");
                    for (String item : summarys) {
                        if (item.equals(strSummary)) {
                            newComboItemList.add(comboItem);
                        }
                    }
                }
            }
        }
        return newComboItemList;
    }

    /**
     * 過濾折扣條件
     *
     * @param discountList
     * @param discountScope  折扣可使用范围
     * @param placeOrderType 落單類型
     * @return
     */
    public static List<Discount> discountConditionFilter(List<Discount> discountList, byte discountScope, byte placeOrderType) {
        String strScope = String.valueOf(discountScope);
        String strType = String.valueOf(placeOrderType);

        Map<String, Discount> newDiscountMaps = new HashMap<>();
        for (Discount discount : discountList) {
            newDiscountMaps.put(discount.getId() + "-" + discount.getDiscountType() + "-" + discount.getPlaceOrderType(), discount);
        }
        List<Discount> newDiscountList = new ArrayList<>();
        for (String key : newDiscountMaps.keySet()) {
            String[] keys = key.split("-");
            if (keys.length == 3) {
                String[] scopeKeys = keys[1].split(",");
                String[] typeKeFys = keys[2].split(",");
                int condtionCount = 0;
                for (String scopeKey : scopeKeys) {
                    if (scopeKey.contains(String.valueOf(Discount.discount_scope_ALL)) || scopeKey.contains(strScope)) {
                        condtionCount++;
                    }
                }
                for (String typeKey : typeKeFys) {
                    if (typeKey.contains(strType)) {
                        condtionCount++;
                    }
                }
                if (condtionCount == 2) {
                    Discount discount = newDiscountMaps.get(key);
                    newDiscountList.add(discount);
                }
            }
        }

        return newDiscountList;
    }

}
