package com.gingersoft.gsa.cloud.print;

import android.util.Log;

import java.util.List;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/2/5
 * Time: 16:38
 * Use: 將需要打印的數據傳進來，這裡就會進行打印，並且處理對應的狀態
 */
public class NewPrintExecutor {

    private static NewPrintExecutor newPrintExecutor;
    private String ip;
    private int port;

    public static NewPrintExecutor getInstance() {
        if (newPrintExecutor == null) {
            newPrintExecutor = new NewPrintExecutor();
        }
        return newPrintExecutor;
    }

    private PrintSocketHolder.OnStateChangedListener onStateChangedListener;
    private PrintExecutor.OnPrintResultListener onPrintResultListener;

    public NewPrintExecutor setConnect(String ip, int port) {
        this.ip = ip;
        this.port = port;
        return this;
    }


    public void print() {
        Request request = new Request.Builder()
                .url("http://" + ip + ":" + port)
                .build();
        OkHttpClient client = new OkHttpClient();
        client.newWebSocket(request, new WebSocketListener() {
            @Override
            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                Log.e("aaa", "連接已打開");
            }

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                Log.e("aaa", "onMessage：" + text);
            }

            @Override
            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
                Log.e("aaa", "onMessage2：" + bytes);
            }

            @Override
            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                Log.e("aaa", "onClosing" + code + reason);
            }

            @Override
            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                Log.e("aaa", "onClosed" + code + reason);
            }

            @Override
            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                Log.e("aaa", "onFailure" + t.getMessage());
            }
        });
        client.dispatcher().executorService().shutdown();
    }

    /**
     * 设置状态监听
     *
     * @param listener 监听
     */
    public void setOnStateChangedListener(PrintSocketHolder.OnStateChangedListener listener) {
        onStateChangedListener = listener;
    }

    /**
     * 设置结果回调
     *
     * @param listener 回调
     */
    public void setOnPrintResultListener(PrintExecutor.OnPrintResultListener listener) {
        onPrintResultListener = listener;
    }


}
