package com.gingersoft.gsa.cloud.ui.adapter.bean;

import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.EditorInfo;

import lombok.Data;
import me.yokeyword.fragmentation.ISupportFragment;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 14:15
 * Use: 多類型輸入
 */
@Data
public class MultiInputBean extends InfoMultiBean {

    private InputFilter[] inputFilters = new InputFilter[0];
    private int inputType = EditorInfo.TYPE_CLASS_TEXT | EditorInfo.TYPE_TEXT_FLAG_MULTI_LINE;
    private int maxLength = 0;
    /**
     * 是否可以編輯
     */
    private boolean isEdit = true;
    /**
     * 輸入框的焦點事件
     */
    private View.OnFocusChangeListener onFocusChangeListener;

    private MultiInputBean() {
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText) {
        super(itemType, showTitle, isRequired, hintText);
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
    }
    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters, View.OnFocusChangeListener onFocusChangeListener) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
        this.onFocusChangeListener = onFocusChangeListener;
    }
    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, int type) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputType = type;
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue) {
        super(itemType, showTitle, isRequired, hintText, showValue);
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters, int type) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
        this.inputType = type;
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue, Class<? extends ISupportFragment> supportFragment) {
        super(itemType, showTitle, isRequired, hintText, showValue);
        this.fragment = supportFragment;
    }
}
