package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseWarehousingOrderDetailsVO;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/6
 * Time: 16:36
 * Use:庫存查詢的訂單列表
 */
public class WarehousingQueryAdapter extends BaseQuickAdapter<PurchaseWarehousingOrderDetailsVO, BaseViewHolder> {

    private Context context;
    private int[] colors = new int[]{R.color.color_f9, R.color.white};

    public WarehousingQueryAdapter(Context context, List<PurchaseWarehousingOrderDetailsVO> purchaseWarehousingOrderDetailsVosBeans) {
        super(R.layout.item_warehousing_query, purchaseWarehousingOrderDetailsVosBeans);
        addChildClickViewIds(R.id.layout_inventory_quantity);
        this.context = context;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseWarehousingOrderDetailsVO item) {
        viewHolder.setText(R.id.tv_warehouse_item_ingredients_name, item.getName());
        viewHolder.setGone(R.id.tv_warehouse_item_ingredients_name, false);
        viewHolder.setText(R.id.tv_warehouse_item_ingredients_species, item.getFoodCategoryName());
        viewHolder.setText(R.id.tv_warehouse_item_unit, item.getUnitName());
//        viewHolder.setText(R.id.tv_warehouse_item_unit_price, String.format(context.getString(R.string.str_amount_tran_s), MoneyUtil.formatDouble(item.getFoodPrice())));
        viewHolder.setText(R.id.tv_warehouse_item_unit_price, MoneyUtil.formatDouble(item.getFoodPrice()));
        viewHolder.setText(R.id.tv_warehouse_item_inventory_quantity, item.getFoodNum() + "");
//        viewHolder.setText(R.id.tv_warehouse_item_total_amount, String.format(context.getString(R.string.str_amount_tran_s), MoneyUtil.formatDouble(item.getFoodAmount())));
        viewHolder.setText(R.id.tv_warehouse_item_total_amount, MoneyUtil.formatDouble(item.getFoodAmount()));
        int textColorRes = getColor(R.color.color_3c);
        setTextColor(viewHolder, textColorRes);
        int colorRes = getColor(colors[viewHolder.getAdapterPosition() % 2]);
        viewHolder.setBackgroundColor(R.id.tv_head_layout_res_id, colorRes);
        viewHolder.setGone(R.id.iv_unit_price_sort, true);
        viewHolder.setGone(R.id.iv_inventory_quantity_sort, true);
        viewHolder.setGone(R.id.iv_total_amount_sort, true);
    }

    private void setTextColor(@NotNull BaseViewHolder viewHolder, int textColorRes) {
        viewHolder.setTextColor(R.id.tv_warehouse_item_ingredients_name, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_ingredients_species, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_supplier, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_unit, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_unit_price, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_inventory_quantity, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_total_amount, textColorRes);
    }

    private int getColor(int colorRes) {
        return ContextCompat.getColor(context, colorRes);
    }
}
