package com.gingersoft.gsa.cloud.ui.adapter;

import android.content.res.ColorStateList;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.TagViewItem;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButton;

import java.util.List;

public class TagViewAdapter extends BaseQuickAdapter<TagViewItem, BaseViewHolder> {

    public TagViewAdapter(@Nullable List<TagViewItem> data) {
        super(R.layout.item_tag_view, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, TagViewItem item) {
        QMUIRoundButton roundButton = helper.getView(R.id.btn_tag);
        roundButton.setText(item.getText());
        roundButton.setTextSize(item.getTextSize());
        if (item.isChecked()) {
            roundButton.setBackgroundColor(item.getCheckedBgColor());
            roundButton.setStrokeColors(ColorStateList.valueOf(item.getCheckedBgColor()));
            roundButton.setTextColor(item.getCheckedTextColor());
        } else {
            roundButton.setBackgroundColor(item.getUnCheckedBgColor());
            roundButton.setStrokeColors(ColorStateList.valueOf(item.getSidelineColor()));
            roundButton.setTextColor(item.getUnCheckedTextColor());
        }
    }

}
