package com.gingersoft.supply_chain.mvp.ui.widget;

import android.annotation.SuppressLint;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;
import com.jess.arms.utils.DeviceUtils;
import com.lxj.xpopup.core.BottomPopupView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/18
 * Time: 10:01
 * Use: 掃描sn碼彈窗
 */
public class ScanSnPopup extends BottomPopupView {

    private final String foodName;
    private final List<PurchaseFoodEncodeSn> snCodes;
    private final Fragment fragment;
    private final boolean operable;
    @BindView(R2.id.tv_food_Ingredients_name)
    TextView tvFoodIngredientsName;
    @BindView(R2.id.tv_food_inbound_quantity)
    TextView tvFoodInboundQuantity;
    @BindView(R2.id.layout_scan_sn)
    LinearLayout rootLayout;
    private OnScanResultListener onScanResultListener;
    private PopupWindow.OnDismissListener onDismissListener;
    private ScanSnView.OnDeleteSnCodeListener onDeleteListener;
    /**
     * 最大掃碼數量
     */
    private int maxCodeSize = -1;
    /**
     * 最少掃碼數量
     */
    private int minCodeSize = 0;

    public ScanSnPopup(@NonNull Fragment fragment, String foodName, List<PurchaseFoodEncodeSn> purchaseFoodEncodeSns, boolean operable) {
        super(fragment.requireContext());
        if (purchaseFoodEncodeSns == null) {
            purchaseFoodEncodeSns = new ArrayList<>();
        }
        this.foodName = foodName;
        this.snCodes = purchaseFoodEncodeSns;
        this.fragment = fragment;
        this.operable = operable;
        addInnerContent();
    }

    public ScanSnPopup setOnScanResultListener(OnScanResultListener onScanResultListener) {
        this.onScanResultListener = onScanResultListener;
        return this;
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.popup_scan_sn;
    }

    @Override
    @SuppressLint("ClickableViewAccessibility")
    protected void initPopupContent() {
        super.initPopupContent();
        ButterKnife.bind(this);
        tvFoodIngredientsName.setText(foodName);
        tvFoodInboundQuantity.setText(String.valueOf(snCodes.size()));
        if (operable) {
            rootLayout.addView(new ScanSnView(fragment, snCodes, (popup, scanResult) -> onScanResultListener.onScanResult(ScanSnPopup.this, scanResult))
                            .setOnDeleteSnCodeListener(onDeleteListener)
                            .setOnCancelListener(this::dismiss)
                            .setMinCodeSize(minCodeSize)
                            .setMaxCodeSize(maxCodeSize)
                            .setOnSingerResultListener((isAdd, snCode, currentSnCodeNumber) -> {
                                //每掃描出一個調用
                                tvFoodInboundQuantity.setText(String.valueOf(currentSnCodeNumber));
                            }).init()
                    , new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        } else {
            rootLayout.addView(new ShowSnView(getContext(), snCodes));
        }
    }

    public ScanSnPopup setMaxCodeSize(int maxCodeSize) {
        this.maxCodeSize = maxCodeSize;
        return this;
    }

    public ScanSnPopup setMinCodeSize(int minCodeSize) {
        this.minCodeSize = minCodeSize;
        return this;
    }

    @Override
    protected int getMaxHeight() {
        return (int) (DeviceUtils.getScreenHeight(getContext()) / 2);
    }

//    @Override
//    protected int getPopupHeight() {
//        return (int) (DeviceUtils.getScreenHeight(getContext()) / 2);
//    }

    public interface OnScanResultListener {
        /**
         * 掃完碼確認之後回調
         *
         * @param scanResult 本次掃碼結果
         */
        void onScanResult(ScanSnPopup popup, List<PurchaseFoodEncodeSn> scanResult);
    }

    public ScanSnPopup setOnDeleteListener(ScanSnView.OnDeleteSnCodeListener onDeleteListener) {
        this.onDeleteListener = onDeleteListener;
        return this;
    }

    public ScanSnPopup setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        if (onDismissListener != null) {
            onDismissListener.onDismiss();
        }
    }
}
