package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealSoldoutContract;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealStyleUtils;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/22/2020 10:39
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MealSoldoutModel extends BaseModel implements MealSoldoutContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public MealSoldoutModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Food> queryDB_FoodListByIds(String[] ids) {
        String sql = "SELECT * FROM FOOD WHERE id IN ( ?, ? );";
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        return MealStyleUtils.assemblyFoodsColor(foodDaoUtils.queryFoodByNativeSql(sql, ids));
    }

    @Override
    public List<Food> queryDB_AllFoodList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        return MealStyleUtils.assemblyFoodsColor(foodDaoUtils.queryAllFoodByQueryBuilder());
    }

    @Override
    public List<Food> queryDB_FoodGroupList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        return MealStyleUtils.assemblyFoodsColor(foodDaoUtils.queryFoodGroupByQueryBuilder());
    }

    @Override
    public List<Food> queryDB_FoodList(long parentId) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        return MealStyleUtils.assemblyFoodsColor(foodDaoUtils.queryFoodByQueryBuilder(parentId));
    }

    @Override
    public Single<BaseResult> getCurrentSoldoutFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getCurrentSoldoutFood(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> insertSoldoutCtrl(RequestBody requestBody, int operatTtpe, int type) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .insertSoldoutCtrl(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
//                .flatMap(new Function<BaseResult, Single<BaseResult>>() {
//                    @Override
//                    public Single<BaseResult> apply(BaseResult info) throws Exception {
//                        if (info != null && info.isSuccess()) {
//                            if (operatTtpe == 0) {
//                                int restaurantId = ResturantInfoManager.newInstance().getRestaurantId();
//                                switch (type) {
//                                    case 1:
//                                    case 2:
//                                        //更新食品狀態
//                                        return downFoodList(restaurantId);
//                                    case 3:
//                                        //更新細項狀態
//                                        return downFoodModifier(restaurantId);
//                                }
//                            }
//                        }
//                        return Single.just(info);
//                    }
//                });
    }

    @Override
    public Single<BaseResult> restoreSoldoutCtrl(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .restoreSoldoutCtrl(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> batchRestoreSoldoutCtrl(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .batchRestoreSoldoutCtrl(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> updateInvisible(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .updateInvisible(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> downFoodList(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .downFoodList(restaurantId)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> downFoodModifier(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .downFoodModifier(restaurantId)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

}