package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;

import io.reactivex.Single;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/1/17.
 */
public interface OrderService {

    @FormUrlEncoded
    @POST("order/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> loadOrderList(@Field("restaurantId") int restaurantId, @Field("orderType") String orderType,@Field("status") String status ,@Field("pageIndex") int pageIndex, @Field("pageSize") int pageSize);

    @GET("order/pay/success" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getOrderDetail(@Query("orderId") long orderId);

    @GET("order/findOrderById" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> getOrderById(@Query("orderId") long orderId);

    @FormUrlEncoded
    @POST("order/cancel" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> cancelOrder(@Field("orderId") long orderId);

    @POST("posPay/getTxnId" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getTxnId(@Body RequestBody requestBody);
}
