package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.order.order.MealOrder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.ui.adapter.ViewPager2Adapter;
import com.gingersoft.gsa.cloud.ui.utils.QMUITabSegmentUtils;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;

/**
 * @作者: bin
 * @創建時間: 2021-04-02 17:14
 * @更新時間: 2021-04-02 17:14
 * @描述:
 */
public class DiscountFragment extends BaseFragment<BasePresenter> implements IView {

    private final String TAG = "DiscountFragment";

    @BindView(R2.id.tabSegment)
    QMUITabSegment2 tabSegment;
    @BindView(R2.id.viewPager)
    ViewPager2 viewPager;
    @BindView(R2.id.ll_container)
    QMUILinearLayout llContainer;
    private int mCurrentPageIndex = 0;

    private CouponFragment couponFragment;

    public static DiscountFragment newInstance() {
        DiscountFragment fragment = new DiscountFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_dialog_discout, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        float mShadowAlpha = 0.25f;
        int mShadowElevationDp = 14;
        llContainer.setRadiusAndShadow(15, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        initTabAndPager();
    }

    @Override
    public void setData(@Nullable Object data) {
    }

    private void initTabAndPager() {

        final List<String> tabList = getTabTitles();

        QMUITabBuilder builder = tabSegment.tabBuilder();
        for (final String tabTitle : tabList) {
            QMUITab tab = builder
                    .setText(tabTitle)
                    .build(mContext);
            tabSegment.addTab(tab);
        }
        viewPager.setAdapter(new ViewPager2Adapter(this, createFragments()));
        viewPager.setCurrentItem(mCurrentPageIndex);
        tabSegment.addOnTabSelectedListener(new QMUITabSegment.OnTabSelectedListener() {

            @Override
            public void onTabSelected(int index) {
                LoganManager.w_tableMode(TAG, "當前頁面【" + tabList.get(index) + "】");
            }

            @Override
            public void onTabUnselected(int index) {
            }

            @Override
            public void onTabReselected(int index) {
            }

            @Override
            public void onDoubleTap(int index) {
            }
        });
        QMUITabSegmentUtils.setNomalTabSegmentStyle(tabSegment, viewPager);
    }

    private List<Fragment> createFragments() {
        List<Fragment> fragments = new ArrayList<>();
        NomalDiscountFragment billDiscountFragment = NomalDiscountFragment.newInstance();
        billDiscountFragment.setOnDiscountItemClickListener((item, position) -> {
            if (onDiscountItemClickListener != null) {
                onDiscountItemClickListener.onBillDiscountClick(item, position);
            }
        });
        fragments.add(billDiscountFragment);
        MemberInfo memberInfo = MealOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            couponFragment = CouponFragment.newInstance(CouponFragment.FOOD_LIMIT_DISCOUNT);
            couponFragment.setOnCouponItemClickListener((item, position) -> {
                if (onDiscountItemClickListener != null) {
                    onDiscountItemClickListener.onCouponClick(item, position);
                }
            });
            fragments.add(couponFragment);
        }
        return fragments;
    }

    private List<String> getTabTitles() {
        List<String> tabList = new ArrayList<>();
        tabList.add("折扣");
        MemberInfo memberInfo = MealOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            tabList.add("會員錢包");
        }
        return tabList;
    }


    private OnDiscountItemClickListener onDiscountItemClickListener;

    public void setOnDiscountItemClickListener(OnDiscountItemClickListener onDiscountItemClickListener) {
        this.onDiscountItemClickListener = onDiscountItemClickListener;
    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(_mActivity, message, true);
        else
            LoadingDialog.showDialogForLoading(_mActivity);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(_mActivity, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        if (intent != null) {
            ArmsUtils.startActivity(intent);
        }
    }

    @Override
    public void killMyself() {
        pop();
        super.onBackPressedSupport();
    }

    public interface OnDiscountItemClickListener {
        void onBillDiscountClick(Discount item, int position);

        void onCouponClick(MemberWalletCoupon item, int position);
    }
}
