package com.gingersoft.gsa.cloud.common.ui.utils

import com.gingersoft.gsa.cloud.common.R
import com.gingersoft.gsa.cloud.common.constans.FunctionManagerConstants
import com.gingersoft.gsa.cloud.database.bean.Function

class BtnBuilder {
    lateinit var functions: List<Function>

    companion object {
        const val SureBtn = 0
        const val CancelBtn = 1
        const val PrintBtn = 2
        const val LogisticsBtn = 3
        const val AssignDeliveryBtn = 4
        const val ClosingBtn = 5
        const val ProductionCompletedBtn = 6
        const val TransportationBtn = 7//選擇運輸工具
        const val AdditionalServiceChargeBtn = 8//追加服務費

        @Volatile
        private var instance: BtnBuilder? = null

        @JvmStatic
        fun getInstance(functions: List<Function>): BtnBuilder {
            instance
                    ?: synchronized(this) {
                        instance
                                ?: BtnBuilder().also { instance = it }
                    }
            instance!!.functions = functions
            return instance!!
        }

    }

    class BtnBean(val type: Int, var btnContent: String, val btnColor: Int, val btnImg: Int)

    fun getSureBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.CONFIRM_BTN_KEY, SureBtn, "確認訂單", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getProductionCompletedBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.PRODUCTION_COMPLETED_BTN_KEY, ProductionCompletedBtn, "製作完成", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getCancelBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.CANCEL_ORDER_BTN_KEY, CancelBtn, "取消訂單", R.color.other_order_details_cancel_btn_color, R.drawable.ic_cancel)
    }

    fun getPrintBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.PRINT_ORDER_BTN_KEY, PrintBtn, "打印訂單", R.color.other_order_details_print_btn_color, R.drawable.ic_print)
    }

    fun getLogisticsBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.LOGISTICS_BTN_KEY, LogisticsBtn, "取消物流", R.color.other_order_details_cancel_logistics_btn_color, R.drawable.ic_logistics)
    }

    fun getAssignDeliveryBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.ASSIGNDELIVERY_BTN_KEY, AssignDeliveryBtn, "指派送貨", R.color.other_order_details_sure_btn_color, R.drawable.ic_deliveryman)
    }

    fun getClosingBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.CLOSING_BTN_KEY, ClosingBtn, "結賬", R.color.other_order_details_cancel_btn_color, R.drawable.ic_closing)
    }

    fun getTransportationBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.TRANSPORTATION_BTN_KEY, TransportationBtn, "運輸工具", R.color.other_order_details_cancel_logistics_btn_color, R.drawable.ic_logistics)
    }

    fun getAdditionalServiceChargeBtn(): BtnBean? {
        return getBtn(FunctionManagerConstants.takeaway.ADDITIONALSERVICECHARGE_BTN_KEY, AdditionalServiceChargeBtn, "追加貼士", R.color.additional_service_charge_btn_color, R.drawable.ic_additional_service_charge)
    }

    private fun getBtn(key: String, btnCode: Int, btnContent: String, btnColor: Int, btnImg: Int): BtnBean? {
        for (value in functions) {
            if (value.resUrl == key) {
                return when {
                    value.status == 3 -> BtnBean(btnCode, btnContent, R.color.color_ccc, btnImg)
//                    value.status == 1 -> BtnBean(btnCode, btnContent, btnColor, btnImg)
                    else -> BtnBean(btnCode, btnContent, btnColor, btnImg)
                }
            }
        }
        return null
//        return BtnBean(btnCode, btnContent, btnColor, btnImg)
    }


}
