package com.gingersoft.gsa.cloud.common.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.jess.arms.utils.DeviceUtils;

public class AddKeyBoard extends FrameLayout {

    private String[] keyString = new String[]{"+10", "+20", "+50", "+100", "7", "8", "9", "X", "4", "5", "6", "0", "1", "2", "3", "確定"};

    private int btnHeight;

    private String amount = "";
    private String decimal = "";

    private int maxValue = 100;

    private onKeyResultListener onKeyResultListener;

    public AddKeyBoard(@NonNull Context context) {
        this(context, null);
    }

    public AddKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public AddKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        btnHeight = (int) (DeviceUtils.getScreenWidth(getContext()) / 6);
        RecyclerView recyclerView = new RecyclerView(getContext());
        recyclerView.setLayoutManager(new StaggeredGridLayoutManager(4, StaggeredGridLayoutManager.VERTICAL));
        recyclerView.setAdapter(new KeyBoardAdapter());
        addView(recyclerView);
    }

    public void setOnKeyResultListener(AddKeyBoard.onKeyResultListener onKeyResultListener) {
        this.onKeyResultListener = onKeyResultListener;
    }

    private class KeyBoardAdapter extends RecyclerView.Adapter<KeyBoardAdapter.ViewHolder> {

        @NonNull
        @Override
        public KeyBoardAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(View.inflate(parent.getContext(), R.layout.item_num_keyboard, null));
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            ViewGroup.LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            holder.itemView.setOnClickListener(v -> {
                if (keyString[position].contains("+")) {
                    long oldAmount;
                    if (amount.contains(".")) {
                        oldAmount = Long.parseLong(amount.substring(0, amount.length() - 1));
                        amount = (oldAmount + Integer.valueOf(keyString[position].substring(1))) + ".";
                    } else {
                        if (amount.length() <= 0) {
                            amount = keyString[position].substring(1);
                        } else {
                            oldAmount = Long.parseLong(amount);
                            amount = (oldAmount + Integer.valueOf(keyString[position].substring(1))) + "";
                        }
                        if (Integer.parseInt(amount) > maxValue) {
                            amount = maxValue + "";
                            ToastUtils.show(getContext(), "追加金額不能超過：" + maxValue);
                        }
                    }
                } else if (keyString[position].equals("X")) {
                    if (decimal.length() > 0) {
                        decimal = decimal.substring(0, decimal.length() - 1);
                    } else if (amount.length() > 0) {
                        amount = amount.substring(0, amount.length() - 1);
                    }
                } else if (!keyString[position].equals("確定")) {
                    if (keyString[position].equals(".")) {
                        //如果是小數點
                        if (!amount.contains(".")) {
                            if (amount.length() > 0) {
                                amount += ".";
                            }
                        }
                    } else {
                        //不是小數點
                        if (amount.contains(".")) {
                            if (decimal.length() >= 2) {
                                ToastUtils.show(getContext(), "最多輸入兩位小數");
                            } else {
                                decimal += keyString[position];
                            }
                        } else {
                            amount += keyString[position];
                            try {
                                if (Integer.parseInt(amount) > maxValue) {
                                    amount = maxValue + "";
                                    ToastUtils.show(getContext(), "追加金額不能超過：" + maxValue);
                                }
                            } catch (NumberFormatException e) {
                                e.printStackTrace();
                                amount = maxValue + "";
                            }
                        }
                    }
                }

                if (keyString[position].equals("確定")) {
                    if (onKeyResultListener != null) {
                        onKeyResultListener.onResult(true, amount + decimal);
                    }
                } else {
                    if (onKeyResultListener != null) {
                        onKeyResultListener.onResult(false, amount + decimal);
                    }
                }
            });

            lp.height = btnHeight;
            if (keyString[position].equals("確定")) {
                holder.tvKey.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.theme_color));
                holder.tvKey.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
            } else if (keyString[position].equals("X")) {
                holder.tvKey.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.red_500));
                holder.tvKey.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
            } else {
                holder.tvKey.setTextColor(ContextCompat.getColor(getContext(), R.color.theme_333_color));
                holder.tvKey.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.white));
            }
            holder.layout.setLayoutParams(lp);
            holder.tvKey.setText(keyString[position]);
        }

        @Override
        public int getItemCount() {
            return keyString.length;
        }

        private class ViewHolder extends RecyclerView.ViewHolder {

            TextView tvKey;
            LinearLayout layout;

            public ViewHolder(@NonNull View itemView) {
                super(itemView);
                tvKey = itemView.findViewById(R.id.tv_keyboard);
                layout = itemView.findViewById(R.id.layout);
            }
        }
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < 0) {
            this.maxValue = 0;
        } else {
            this.maxValue = maxValue;
        }
    }

    public interface onKeyResultListener {
        void onResult(boolean isComplete, String value);
    }
}
