package com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerSelectComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.SelectContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.SelectPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.SelectAdapter;
import com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration.VERTICAL_LIST;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * 餐牌的選擇頁面：默認選擇，排除內容
 */
public class SelectFragment extends BaseFoodMenuFragment<SelectPresenter> implements SelectContract.View {

    @BindView(R2.id.topbar_list)
    QMUITopBar topbarList;
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btn_save;

    private String title;
    private int fragmentType;
    private String itemName;

    public static SelectFragment newInstance(int type, String title) {
        SelectFragment fragment = new SelectFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(FRAGMENT_TYPE, type);
        bundle.putString(TITLE_KEY, title);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSelectComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_select, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            title = arguments.getString(TITLE_KEY);
            fragmentType = arguments.getInt(FRAGMENT_TYPE);
        }
        initTopBar();
        if (fragmentType == SELECT_LIST) {
            itemName = "選擇";
        } else if (fragmentType == SELECT_EXCLUDE_LIST) {
            itemName = "排除";
        }





        rvContent.setLayoutManager(new LinearLayoutManager(mContext));
        List<String> contents = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            contents.add(itemName + i);
        }
        rvContent.addItemDecoration(new DividerItemDecoration(mContext, VERTICAL_LIST));
        rvContent.setAdapter(new SelectAdapter(contents));
    }

    public void initTopBar() {
        topbarList.setTitle(title);
        topbarList.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> {
            FragmentActivity activity = getActivity();
            if (activity != null) {
                activity.onBackPressed();
            }
        });
    }

    /**
     * 通过此方法可以使 Fragment 能够与外界做一些交互和通信, 比如说外部的 Activity 想让自己持有的某个 Fragment 对象执行一些方法,
     * 建议在有多个需要与外界交互的方法时, 统一传 {@link Message}, 通过 what 字段来区分不同的方法, 在 {@link #setData(Object)}
     * 方法中就可以 {@code switch} 做不同的操作, 这样就可以用统一的入口方法做多个不同的操作, 可以起到分发的作用
     * <p>
     * 调用此方法时请注意调用时 Fragment 的生命周期, 如果调用 {@link #setData(Object)} 方法时 {@link Fragment#onCreate(Bundle)} 还没执行
     * 但在 {@link #setData(Object)} 里却调用了 Presenter 的方法, 是会报空的, 因为 Dagger 注入是在 {@link Fragment#onCreate(Bundle)} 方法中执行的
     * 然后才创建的 Presenter, 如果要做一些初始化操作,可以不必让外部调用 {@link #setData(Object)}, 在 {@link #initData(Bundle)} 中初始化就可以了
     * <p>
     * Example usage:
     * <pre>
     * public void setData(@Nullable Object data) {
     *     if (data != null && data instanceof Message) {
     *         switch (((Message) data).what) {
     *             case 0:
     *                 loadData(((Message) data).arg1);
     *                 break;
     *             case 1:
     *                 refreshUI();
     *                 break;
     *             default:
     *                 //do something
     *                 break;
     *         }
     *     }
     * }
     *
     * // call setData(Object):
     * Message data = new Message();
     * data.what = 0;
     * data.arg1 = 1;
     * fragment.setData(data);
     * </pre>
     *
     * @param data 当不需要参数时 {@code data} 可以为 {@code null}
     */
    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
