package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.OrderContentModule;
import com.gingersoft.supply_chain.mvp.contract.OrderContentContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.OrderContentFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/03/2020 17:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = OrderContentModule.class, dependencies = AppComponent.class)
public interface OrderContentComponent {
    void inject(OrderContentFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        OrderContentComponent.Builder view(OrderContentContract.View view);

        OrderContentComponent.Builder appComponent(AppComponent appComponent);

        OrderContentComponent build();
    }
}