package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.mvp.bean.OrderBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderResultBean;
import com.gingersoft.supply_chain.mvp.content.Constant;
import com.gingersoft.supply_chain.mvp.contract.PurchaseListContract;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.MediaType;
import okhttp3.RequestBody;


/**
 * Description:採購列表
 */
@FragmentScope
public class PurchaseListPresenter extends BasePresenter<PurchaseListContract.Model, PurchaseListContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public PurchaseListPresenter(PurchaseListContract.Model model, PurchaseListContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getOrderList(String orderNo, int orderStatus, int pageIndex) {
        Map<String, Object> map = new HashMap<>(6);
        Constant.addRestaurantId(map);
        Constant.addBrandId(map);
        Constant.addPageSize(map);

        if (TextUtil.isNotEmptyOrNullOrUndefined(orderNo)) {
            map.put("orderNo", orderNo);
        }
        if (orderStatus != 0) {
            map.put("status", orderStatus);
        }
        map.put("pageIndex", pageIndex);
        mModel.getOrderList(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("獲取中..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<PurchaseOrderResultBean>(mErrorHandler) {
                    @Override
                    public void onNext(@NonNull PurchaseOrderResultBean info) {
                        if (info.isSuccess() && info.getData() != null) {
                            mRootView.loadOrderList(info.getData().getList());
                        }
                    }
                });
    }


    public void deleteOrder(int position, OrderBean orderBean){
        orderBean.setDeletes(Constant.DELETE);
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), GsonUtils.GsonString(orderBean));
        mModel.updateOrder(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("獲取中..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(@NonNull BaseResult info) {
                        if(info.isSuccess()){
                            mRootView.deleteOrder(position);
                        }
                    }
                });
    }
}
