package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.di.component.DaggerFoodIngredientCategoryComponent;
import com.gingersoft.supply_chain.mvp.contract.FoodIngredientCategoryContract;
import com.gingersoft.supply_chain.mvp.presenter.FoodIngredientCategoryPresenter;
import com.jess.arms.di.component.AppComponent;


/**
 * ================================================
 * Description: 食材類別
 */
public class FoodIngredientCategoryFragment extends BaseSupplyChainFragment<FoodIngredientCategoryPresenter> implements FoodIngredientCategoryContract.View {

    public static FoodIngredientCategoryFragment newInstance() {
        FoodIngredientCategoryFragment fragment = new FoodIngredientCategoryFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFoodIngredientCategoryComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_food_ingredient_category, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }
}
